/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigRoot
@ConfigMapping(prefix="quarkus.container-image")
public interface ContainerImageConfig {
    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> group();

    @WithDefault(value="${quarkus.application.name:unset}")
    @WithConverter(value=TrimmedStringConverter.class)
    public String name();

    @WithDefault(value="${quarkus.application.version:latest}")
    public String tag();

    public Optional<List<String>> additionalTags();

    @ConfigDocMapKey(value="label-name")
    public Map<String, String> labels();

    public Optional<String> registry();

    public Optional<String> image();

    public Optional<String> username();

    public Optional<String> password();

    @WithDefault(value="false")
    public boolean insecure();

    public Optional<Boolean> build();

    public Optional<Boolean> push();

    public Optional<String> builder();

    default public boolean isBuildExplicitlyEnabled() {
        return this.build().isPresent() && this.build().get() != false;
    }

    default public boolean isBuildExplicitlyDisabled() {
        return this.build().isPresent() && this.build().get() == false;
    }

    default public boolean isPushExplicitlyEnabled() {
        return this.push().isPresent() && this.push().get() != false;
    }

    default public boolean isPushExplicitlyDisabled() {
        return this.push().isPresent() && this.push().get() == false;
    }
}

