/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.confluent.registry.json;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class ConfluentRegistryJsonProcessor {
    public static final String CONFLUENT_GROUP_ID = "io.confluent";
    public static final String CONFLUENT_ARTIFACT_ID = "kafka-json-schema-serializer";
    private static final Logger LOGGER = Logger.getLogger((String)ConfluentRegistryJsonProcessor.class.getName());
    public static final String CONFLUENT_REPO = "https://packages.confluent.io/maven/";
    public static final String GUIDE_URL = "https://quarkus.io/guides/kafka-schema-registry-json-schema";

    @BuildStep
    FeatureBuildItem featureAndCheckDependency(CurateOutcomeBuildItem cp) {
        if (this.findConfluentSerde(cp.getApplicationModel().getDependencies()).isEmpty()) {
            LOGGER.warnf("The application uses the `quarkus-confluent-registry-json-schema` extension, but does not depend on `%s:%s`. Note that this dependency is only available from the `%s` Maven repository. Check %s for more details.", new Object[]{CONFLUENT_GROUP_ID, CONFLUENT_ARTIFACT_ID, CONFLUENT_REPO, GUIDE_URL});
        }
        return new FeatureBuildItem(Feature.CONFLUENT_REGISTRY_JSON);
    }

    @BuildStep
    public void confluentRegistryJson(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer", "io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer"}).methods().build());
    }

    @BuildStep
    public void configureNative(BuildProducer<NativeImageConfigBuildItem> config, CurateOutcomeBuildItem cp) {
        String version;
        Optional<ResolvedDependency> serde = this.findConfluentSerde(cp.getApplicationModel().getDependencies());
        if (serde.isPresent() && ((version = serde.get().getVersion()).startsWith("7.1") || version.startsWith("7.2"))) {
            config.produce((BuildItem)NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("io.confluent.kafka.schemaregistry.client.rest.utils.UrlList").build());
        }
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.CONFLUENT_REGISTRY_JSON);
    }

    private Optional<ResolvedDependency> findConfluentSerde(Collection<ResolvedDependency> dependencies) {
        return dependencies.stream().filter(new Predicate<ResolvedDependency>(){

            @Override
            public boolean test(ResolvedDependency rd) {
                return rd.getGroupId().equalsIgnoreCase(ConfluentRegistryJsonProcessor.CONFLUENT_GROUP_ID) && rd.getArtifactId().equalsIgnoreCase(ConfluentRegistryJsonProcessor.CONFLUENT_ARTIFACT_ID);
            }
        }).findAny();
    }
}

