/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.deploy;

import io.quarkus.cli.Deploy;
import io.quarkus.cli.common.BuildToolContext;
import io.quarkus.cli.common.BuildToolDelegatingCommand;
import io.quarkus.cli.deploy.KubernetesOptions;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class BaseKubernetesDeployCommand
extends BuildToolDelegatingCommand {
    static final String QUARKUS_DEPLOY_FORMAT = "quarkus.%s.deploy";
    static final String QUARKUS_CONTAINER_IMAGE_BUILD = "quarkus.container-image.build";
    static final String QUARKUS_CONTAINER_IMAGE_BUILDER = "quarkus.container-image.builder";
    static final String DEFAULT_IMAGE_BUILDER = "docker";
    @CommandLine.ArgGroup(order=2, exclusive=false, validate=false, heading="%nKubernetes options:%n")
    KubernetesOptions kubernetesOptions = new KubernetesOptions();
    @CommandLine.ParentCommand
    Deploy parent;

    public Optional<BuildToolDelegatingCommand> getParentCommand() {
        return Optional.of(this.parent);
    }

    public void populateContext(BuildToolContext context) {
        Map properties = context.getPropertiesOptions().properties;
        this.kubernetesOptions.masterUrl.ifPresent(u -> properties.put("quarkus.kubernetes-client.api-server-url", u));
        this.kubernetesOptions.username.ifPresent(u -> properties.put("quarkus.kubernetes-client.username", u));
        this.kubernetesOptions.password.ifPresent(p -> properties.put("quarkus.kubernetes-client.password", p));
        this.kubernetesOptions.token.ifPresent(t -> properties.put("quarkus.kubernetes-client.token", t));
        this.kubernetesOptions.namespace.ifPresent(n -> properties.put("quarkus.kubernetes-client.namespace", n));
        this.kubernetesOptions.caCertFile.ifPresent(c -> properties.put("quarkus.kubernetes-client.ca-cert-file", c));
        this.kubernetesOptions.caCertData.ifPresent(c -> properties.put("quarkus.kubernetes-client.ca-cert-data", c));
        this.kubernetesOptions.clientCertFile.ifPresent(c -> properties.put("quarkus.kubernetes-client.client-cert-file", c));
        this.kubernetesOptions.clientCertData.ifPresent(c -> properties.put("quarkus.kubernetes-client.client-cert-data", c));
        this.kubernetesOptions.clientKeyFile.ifPresent(c -> properties.put("quarkus.kubernetes-client.client-key-file", c));
        this.kubernetesOptions.clientKeyData.ifPresent(c -> properties.put("quarkus.kubernetes-client.client-key-data", c));
        this.kubernetesOptions.clientKeyAlgo.ifPresent(c -> properties.put("quarkus.kubernetes-client.client-key-algo", c));
        this.kubernetesOptions.clientKeyPassphrase.ifPresent(c -> properties.put("quarkus.kubernetes-client.client-key-passphrase", c));
        this.kubernetesOptions.httpProxy.ifPresent(p -> properties.put("quarkus.kubernetes-client.http-proxy", p));
        this.kubernetesOptions.httpsProxy.ifPresent(p -> properties.put("quarkus.kubernetes-client.https-proxy", p));
        this.kubernetesOptions.proxyUsername.ifPresent(p -> properties.put("quarkus.kubernetes-client.proxy-username", p));
        this.kubernetesOptions.proxyPassword.ifPresent(p -> properties.put("quarkus.kubernetes-client.proxy-password", p));
        if (this.kubernetesOptions.noProxy != null && this.kubernetesOptions.noProxy.length > 0) {
            properties.put("quarkus.kubernetes-client.no-proxy", Arrays.stream(this.kubernetesOptions.noProxy).collect(Collectors.joining(", ")));
        }
        properties.put(QUARKUS_CONTAINER_IMAGE_BUILD, String.valueOf(this.kubernetesOptions.imageBuilder.isPresent()));
        this.kubernetesOptions.imageBuilder.or(this.implicitImageBuilder()).ifPresent(builder -> {
            properties.put(QUARKUS_CONTAINER_IMAGE_BUILD, "true");
            properties.put(QUARKUS_CONTAINER_IMAGE_BUILDER, builder);
        });
    }

    public void prepareGradle(BuildToolContext context) {
        super.prepareGradle(context);
        Map properties = context.getPropertiesOptions().properties;
        Optional<String> builder = Optional.ofNullable((String)properties.remove(QUARKUS_CONTAINER_IMAGE_BUILDER));
        builder.or(this.implicitImageBuilder()).ifPresent(b -> context.getParams().add("--image-builder=" + b));
        boolean imageBuild = Optional.ofNullable((String)properties.remove(QUARKUS_CONTAINER_IMAGE_BUILD)).map(Boolean::parseBoolean).orElse(false);
        if (imageBuild) {
            context.getParams().add("--image-build");
        }
    }

    public Supplier<Optional<String>> implicitImageBuilder() {
        return () -> this.kubernetesOptions.imageBuild ? Optional.of(this.getDefaultImageBuilder()) : Optional.empty();
    }

    public String getDefaultImageBuilder() {
        return DEFAULT_IMAGE_BUILDER;
    }
}

