/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.BaseBuildCommand;
import io.quarkus.cli.common.ListFormatOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.TargetQuarkusPlatformGroup;
import io.quarkus.cli.common.build.BuildSystemRunner;
import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.registry.RegistryResolutionException;
import java.nio.file.Path;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, header={"List platforms and extensions. "}, footer={"%nList modes:%n", "(relative). Active when invoked within a project unless an explicit release is specified. The current project configuration will determine what extensions are listed, with installed (available) extensions listed by default.%n", "(absolute). Active when invoked outside of a project or when an explicit release is specified. All extensions for the specified release will be listed. The CLI release will be used if this command is invoked outside of a project and no other release is specified.%n"})
public class ProjectExtensionsList
extends BaseBuildCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;
    @CommandLine.ArgGroup(order=2, heading="%nQuarkus version (absolute):%n")
    TargetQuarkusPlatformGroup targetQuarkusVersion = new TargetQuarkusPlatformGroup();
    @CommandLine.Option(names={"-i", "--installable"}, defaultValue="false", order=2, description={"List extensions that can be installed (relative)"})
    boolean installable = false;
    @CommandLine.Option(names={"-s", "--search"}, defaultValue="*", paramLabel="PATTERN", order=3, description={"Search for matching extensions (simple glob using '*' and '?')."})
    String searchPattern;
    @CommandLine.Option(names={"-c", "--category"}, defaultValue="", paramLabel="CATEGORY_ID", order=4, description={"Only list extensions from the specified category."})
    String category;
    @CommandLine.ArgGroup(heading="%nOutput format:%n")
    ListFormatOptions format = new ListFormatOptions();

    @Override
    public Integer call() {
        try {
            boolean categorySet;
            this.output.debug("List extensions with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool((Path)this.projectRoot());
            boolean bl = categorySet = this.category != null && !this.category.isBlank();
            if (buildTool == null || this.targetQuarkusVersion.isPlatformSpecified() || this.targetQuarkusVersion.isStreamSpecified()) {
                this.installable = false;
                boolean formatSpecified = this.format.isSpecified();
                if (this.runMode.isDryRun()) {
                    return this.dryRunList(this.spec.commandLine().getHelp(), null);
                }
                Integer exitCode = this.listPlatformExtensions();
                this.printHints(buildTool, !formatSpecified, !categorySet, buildTool != null);
                return exitCode;
            }
            BuildSystemRunner runner = this.getRunner();
            if (this.runMode.isDryRun()) {
                return this.dryRunList(this.spec.commandLine().getHelp(), runner.getBuildTool());
            }
            Integer exitCode = runner.listExtensions(this.runMode, this.format, this.installable, this.searchPattern, this.category);
            this.printHints(buildTool, !this.format.isSpecified(), this.installable && !categorySet, this.installable);
            return exitCode;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to list extensions: " + e.getMessage());
        }
    }

    Integer dryRunList(CommandLine.Help help, BuildTool buildTool) {
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        if (buildTool == null) {
            this.output.printText(new String[]{"\nList extensions for specified platform\n", "\t" + this.targetQuarkusVersion.dryRun()});
        } else {
            this.output.printText(new String[]{"\nList extensions for current project\n", "\t" + this.projectRoot().toString()});
            dryRunOutput.put("Build tool", buildTool.name());
        }
        dryRunOutput.put("Batch (non-interactive mode)", Boolean.toString(this.runMode.isBatchMode()));
        dryRunOutput.put("List format", this.format.getFormatString());
        dryRunOutput.put("List installable extensions", Boolean.toString(this.installable));
        dryRunOutput.put("Search pattern", this.searchPattern);
        dryRunOutput.put("Category", this.category);
        dryRunOutput.put("Registry Client", Boolean.toString(this.registryClient.enabled()));
        this.output.info(help.createTextTable(dryRunOutput).toString());
        return 0;
    }

    Integer listPlatformExtensions() throws QuarkusCommandException, RegistryResolutionException {
        QuarkusProject qp = this.registryClient.createQuarkusProject(this.projectRoot(), this.targetQuarkusVersion, BuildTool.MAVEN, this.output);
        QuarkusCommandOutcome outcome = new ListExtensions(qp, (MessageWriter)this.output).fromCli(true).all(true).format(this.format.getFormatString()).search(this.searchPattern).category(this.category).batchMode(this.runMode.isBatchMode()).execute();
        return outcome.isSuccess() ? 0 : 1;
    }

    private void printHints(BuildTool buildTool, boolean formatHint, boolean filterHint, boolean addExtensionHint) {
        if (this.runMode.isBatchMode()) {
            return;
        }
        if (formatHint) {
            this.output.info("");
            this.output.info("To get more information, append `%s` to your command line.", new Object[]{"--full"});
        }
        if (filterHint) {
            this.output.info("");
            this.output.info("To list only extensions from specific category, append `%s` to your command line.", new Object[]{"--category \"categoryId\""});
        }
        if (addExtensionHint) {
            this.output.info("");
            if (BuildTool.GRADLE.equals((Object)buildTool) || BuildTool.GRADLE_KOTLIN_DSL.equals((Object)buildTool)) {
                this.output.info("Add an extension to your project by adding the dependency to your %s or use `%s`", new Object[]{"build.gradle", "quarkus extension add \"artifactId\""});
            } else if (BuildTool.MAVEN.equals((Object)buildTool)) {
                this.output.info("Add an extension to your project by adding the dependency to your %s or use `%s`", new Object[]{"pom.xml", "quarkus extension add \"artifactId\""});
            }
        }
    }

    public String toString() {
        return "ProjectExtensionList [format=" + String.valueOf(this.format) + ", installable=" + this.installable + ", searchPattern=" + this.searchPattern + ", output=" + String.valueOf(this.output) + ", runMode=" + String.valueOf(this.runMode) + "]";
    }
}

