/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import io.quarkus.cli.Version;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.PlatformStreamCoords;
import picocli.CommandLine;

public class TargetQuarkusPlatformGroup {
    static final String FULL_EXAMPLE = "io.quarkus.platform:quarkus-bom:3.15.2";
    PlatformStreamCoords streamCoords = null;
    String validStream = null;
    ArtifactCoords platformBom = null;
    String validPlatformBom = null;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @CommandLine.Option(paramLabel="platformKey:streamId", names={"-S", "--stream"}, description={"A target stream, for example:%n  3.15 or io.quarkus.platform:3.15"})
    void setStream(String stream) {
        if (!(stream = stream.trim()).isEmpty()) {
            try {
                this.streamCoords = PlatformStreamCoords.fromString((String)stream);
                this.validStream = stream;
            }
            catch (IllegalArgumentException iex) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Invalid value '%s' for option '--stream'. Value should be specified as 'platformKey:streamId'. %s", stream, iex.getMessage()));
            }
        }
    }

    @CommandLine.Option(paramLabel="groupId:artifactId:version", names={"-P", "--platform-bom"}, description={"A specific Quarkus platform BOM, for example:%n  io.quarkus.platform:quarkus-bom:3.15.2%n  io.quarkus::999-SNAPSHOT  3.15.2%nDefault groupId: io.quarkus.platform%nDefault artifactId: quarkus-bom%n"})
    void setPlatformBom(String bom) {
        if (!(bom = bom.replaceFirst("^::", "").trim()).isEmpty()) {
            try {
                int firstPos = bom.indexOf(":");
                int lastPos = bom.lastIndexOf(":");
                if (lastPos <= 0) {
                    this.setBom("io.quarkus.platform", "quarkus-bom", bom);
                } else if (lastPos == firstPos + 1) {
                    if (lastPos == bom.length() - 1) {
                        this.setBom(bom.substring(0, firstPos), "quarkus-bom", Version.clientVersion());
                    } else {
                        this.setBom(bom.substring(0, firstPos), "quarkus-bom", bom.substring(lastPos + 1));
                    }
                } else if (firstPos == 0 && lastPos == bom.length() - 1) {
                    this.setBom("io.quarkus.platform", bom.substring(1, lastPos), Version.clientVersion());
                } else {
                    this.platformBom = ArtifactCoords.fromString((String)bom);
                    this.validPlatformBom = bom;
                }
            }
            catch (IllegalArgumentException iex) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Invalid value '%s' for option '--platform-bom'. Value should be specified as 'GROUP-ID:ARTIFACT-ID:VERSION'. %s", bom, iex.getMessage()));
            }
        }
    }

    public boolean isPlatformSpecified() {
        return this.platformBom != null;
    }

    public ArtifactCoords getPlatformBom() {
        return this.platformBom;
    }

    public boolean isStreamSpecified() {
        return this.streamCoords != null;
    }

    public PlatformStreamCoords getStream() {
        return this.streamCoords;
    }

    public String dryRun() {
        if (this.streamCoords != null) {
            return "stream " + this.validStream;
        }
        if (this.platformBom != null) {
            return "platform " + this.validPlatformBom;
        }
        return "same as project";
    }

    public String toString() {
        return "TargetQuarkusVersionGroup{stream=" + String.valueOf(this.streamCoords) + ", platformBom=" + String.valueOf(this.platformBom) + "}";
    }

    private void setBom(String groupId, String artifactId, String version) {
        this.platformBom = ArtifactCoords.pom((String)groupId, (String)artifactId, (String)version);
        this.validPlatformBom = groupId + ":" + artifactId + ":" + version;
    }
}

