/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.devtools.commands.CreateProjectHelper;
import io.quarkus.platform.tools.ToolsUtils;
import java.util.Collections;
import java.util.Map;
import picocli.CommandLine;

public class CodeGenerationGroup {
    String packageName;
    Map<String, String> appConfig = Collections.emptyMap();
    @CommandLine.Option(names={"--no-wrapper"}, description={"Include a buildtool wrapper (e.g. mvnw, gradlew)"}, negatable=true)
    public boolean includeWrapper = true;
    @CommandLine.Option(names={"--no-code"}, description={"Include starter code provided by extensions or generate an empty project"}, negatable=true)
    public boolean includeCode = true;
    @CommandLine.Option(names={"--no-dockerfiles"}, description={"Include standard dockerfiles"}, negatable=true)
    public boolean includeDockerfiles = true;

    @CommandLine.Option(paramLabel="PACKAGE-NAME", names={"--package-name"}, description={"Base package for generated classes"})
    void setPackageName(String name) {
        this.packageName = CreateProjectHelper.checkPackageName((String)name);
    }

    public String getPackageName() {
        return this.packageName;
    }

    @CommandLine.Option(names={"-c", "--app-config"}, description={"Configuration attributes to be set in the application.properties/yml file. Specify as 'key1=value1,key2=value2'"})
    void setAppConfig(String config) {
        if (config.trim().length() > 0) {
            this.appConfig = ToolsUtils.stringToMap((String)config, (String)",", (String)"=");
        }
    }

    public Map<String, String> getAppConfig() {
        return this.appConfig;
    }

    public String toString() {
        return "CodeGenerationGroup [includeCode=" + this.includeCode + ", includeWrapper=" + this.includeWrapper + ", includeDockerfiles=" + this.includeDockerfiles + ", packageName=" + this.packageName + "]";
    }
}

