/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import java.util.Optional;
import picocli.CommandLine;

public class ExtensionCodeGenerationGroup {
    @CommandLine.Option(names={"-C", "--codestart"}, description={"Generate extension codestart"}, negatable=true)
    boolean codestart = false;
    @CommandLine.Option(names={"--no-unit-test"}, description={"Generate unit tests"}, negatable=true)
    boolean unitTest = true;
    @CommandLine.Option(names={"--no-it-test"}, description={"Generate integration test"}, negatable=true)
    boolean integrationTests = true;
    @CommandLine.Option(names={"--no-devmode-test"}, description={"Generate dev mode tests"}, negatable=true)
    boolean devModeTest = true;
    @CommandLine.Option(names={"--without-tests"}, description={"Do not generate any tests (disable all)"})
    Optional<Boolean> withoutTests;

    public boolean withCodestart() {
        return this.codestart;
    }

    public boolean skipUnitTest() {
        return this.withoutTests.orElse(!this.unitTest);
    }

    public boolean skipIntegrationTests() {
        return this.withoutTests.orElse(!this.integrationTests);
    }

    public boolean skipDevModeTest() {
        return this.withoutTests.orElse(!this.devModeTest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExtensionCodeGenerationGroup{");
        sb.append("codestart=").append(this.codestart);
        sb.append(", unitTest=").append(this.unitTest);
        sb.append(", integrationTests=").append(this.integrationTests);
        sb.append(", devModeTest=").append(this.devModeTest);
        sb.append(", withoutTests=").append(this.withoutTests);
        sb.append('}');
        return sb.toString();
    }
}

