/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.BuildReport;
import io.quarkus.cli.build.BaseBuildCommand;
import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.devtools.project.BuildTool;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="build", showEndOfOptionsDelimiterInUsageHelp=true, header={"Build the current project."})
public class Build
extends BaseBuildCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    protected RunModeOption runMode;
    @CommandLine.ArgGroup(order=1, exclusive=false, validate=false, heading="%nBuild options:%n")
    BuildOptions buildOptions = new BuildOptions();
    @CommandLine.Parameters(description={"Additional parameters passed to the build system"})
    List<String> params = new ArrayList<String>();

    @Override
    public Integer call() {
        try {
            this.output.debug("Build project with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            BuildSystemRunner runner = this.getRunner();
            if (this.buildOptions.generateReport) {
                this.params.add("-Dquarkus.debug.dump-build-metrics=true");
            }
            BuildSystemRunner.BuildCommandArgs commandArgs = runner.prepareBuild(this.buildOptions, this.runMode, this.params);
            if (this.runMode.isDryRun()) {
                this.dryRunBuild(this.spec.commandLine().getHelp(), runner.getBuildTool(), commandArgs);
                return 0;
            }
            int exitCode = runner.run(commandArgs);
            if (exitCode == 0 && this.buildOptions.generateReport) {
                this.output.printText("\nBuild report available: " + new BuildReport(runner).generate().toPath().toAbsolutePath().toString() + "\n");
            }
            return exitCode;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to build project: " + e.getMessage());
        }
    }

    void dryRunBuild(CommandLine.Help help, BuildTool buildTool, BuildSystemRunner.BuildCommandArgs args) {
        this.output.printText("\nBuild current project\n", "\t" + this.projectRoot().toString());
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        dryRunOutput.put("Build tool", buildTool.name());
        this.output.info(help.createTextTable(dryRunOutput).toString());
        this.output.printText("\nCommand line:\n", args.showCommand());
    }

    public String toString() {
        return "Build [buildOptions=" + String.valueOf(this.buildOptions) + ", properties=" + String.valueOf(this.propertiesOptions.properties) + ", output=" + String.valueOf(this.output) + ", params=" + String.valueOf(this.params) + "]";
    }
}

