/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common.registry;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.TargetQuarkusPlatformGroup;
import io.quarkus.cli.common.VersionHelper;
import io.quarkus.devtools.commands.CreateProjectHelper;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.RegistriesConfig;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import picocli.CommandLine;

public class RegistryClientMixin {
    static final boolean VALIDATE = !Boolean.parseBoolean(System.getenv("REGISTRY_CLIENT_TEST"));
    @CommandLine.Option(names={"--refresh"}, description={"Refresh the local Quarkus extension registry cache"}, defaultValue="false")
    boolean refresh = false;
    @CommandLine.Option(paramLabel="CONFIG", names={"--config"}, description={"Configuration file"})
    String config;

    public final String getRegistryClientProperty() {
        return "-DquarkusRegistryClient=" + this.enabled();
    }

    public boolean enabled() {
        return true;
    }

    public String getConfigArg() {
        return this.config;
    }

    public RegistriesConfig resolveConfig() throws RegistryResolutionException {
        return this.config == null ? RegistriesConfig.resolveConfig() : RegistriesConfig.resolveFromFile((Path)Path.of(this.config, new String[0]));
    }

    public QuarkusProject createQuarkusProject(Path projectRoot, TargetQuarkusPlatformGroup targetVersion, BuildTool buildTool, OutputOptionMixin log) throws RegistryResolutionException {
        return this.createQuarkusProject(projectRoot, targetVersion, buildTool, log, List.of());
    }

    public QuarkusProject createQuarkusProject(Path projectRoot, TargetQuarkusPlatformGroup targetVersion, BuildTool buildTool, OutputOptionMixin log, Collection<String> extensions) throws RegistryResolutionException {
        ExtensionCatalog catalog = this.getExtensionCatalog(targetVersion, log);
        if (VALIDATE && catalog.getQuarkusCoreVersion().startsWith("1.")) {
            throw new UnsupportedOperationException("The version 2 CLI can not be used with Quarkus 1.x projects.\nUse the maven/gradle plugins when working with Quarkus 1.x projects.");
        }
        catalog = CreateProjectHelper.completeCatalog((ExtensionCatalog)catalog, extensions, (MavenArtifactResolver)QuarkusProjectHelper.artifactResolver());
        return QuarkusProjectHelper.getProject((Path)projectRoot, (ExtensionCatalog)catalog, (BuildTool)buildTool, (JavaVersion)JavaVersion.NA, (MessageWriter)log);
    }

    ExtensionCatalog getExtensionCatalog(TargetQuarkusPlatformGroup targetVersion, OutputOptionMixin log) throws RegistryResolutionException {
        ExtensionCatalogResolver catalogResolver;
        log.debug("Resolving Quarkus extension catalog for " + String.valueOf(targetVersion));
        QuarkusProjectHelper.setMessageWriter((MessageWriter)log);
        if (this.enabled()) {
            QuarkusProjectHelper.setToolsConfig((RegistriesConfig)this.resolveConfig());
        }
        if (VALIDATE && targetVersion.isStreamSpecified() && !this.enabled()) {
            throw new UnsupportedOperationException("Specifying a stream (--stream) requires the registry client to resolve resources. Please try again with the registry client enabled (--registry-client)");
        }
        if (targetVersion.isPlatformSpecified()) {
            ArtifactCoords coords = targetVersion.getPlatformBom();
            return ToolsUtils.resolvePlatformDescriptorDirectly((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion(), (MavenArtifactResolver)QuarkusProjectHelper.artifactResolver(), (MessageWriter)log);
        }
        try {
            catalogResolver = this.getExtensionCatalogResolver(log);
        }
        catch (RegistryResolutionException e) {
            log.warn("Configured Quarkus extension registries appear to be unavailable at the moment. It should still be possible to create a project by providing the groupId:artifactId:version of the desired Quarkus platform BOM, e.g. 'quarkus create -P io.quarkus.platform:quarkus-bom:" + VersionHelper.clientVersion() + "'");
            throw e;
        }
        if (!catalogResolver.hasRegistries()) {
            log.debug("Falling back to direct resolution of the platform bom");
            return ToolsUtils.resolvePlatformDescriptorDirectly(null, null, (String)VersionHelper.clientVersion(), (MavenArtifactResolver)QuarkusProjectHelper.artifactResolver(), (MessageWriter)log);
        }
        this.refreshRegistryCache(log);
        if (targetVersion.isStreamSpecified()) {
            return catalogResolver.resolveExtensionCatalog(targetVersion.getStream());
        }
        return catalogResolver.resolveExtensionCatalog();
    }

    public ExtensionCatalogResolver getExtensionCatalogResolver(OutputOptionMixin log) throws RegistryResolutionException {
        return QuarkusProjectHelper.getCatalogResolver((boolean)this.enabled(), (MessageWriter)log);
    }

    public void refreshRegistryCache(OutputOptionMixin log) throws RegistryResolutionException {
        if (!this.refresh) {
            return;
        }
        ExtensionCatalogResolver catalogResolver = this.getExtensionCatalogResolver(log);
        if (!catalogResolver.hasRegistries()) {
            log.warn("Skipping refresh since no registries are configured");
            return;
        }
        log.debug("Refreshing registry cache");
        try {
            catalogResolver.clearRegistryCache();
        }
        catch (Exception e) {
            log.warn("Unable to refresh the registry cache: %s", new Object[]{e.getMessage()});
        }
    }

    public String toString() {
        return "RegistryClientMixin [useRegistryClient=" + this.enabled() + "]";
    }
}

