/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common.build;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.devtools.exec.ExecSupport;
import io.quarkus.devtools.exec.Executable;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ExecuteUtil {
    private static ExecSupport withOutput(OutputOptionMixin output) {
        return new ExecSupport(output.out(), output.err(), output.isVerbose(), output.isCliTest());
    }

    public static File findExecutableFile(String base) {
        return Executable.findExecutableFile((String)base);
    }

    private static String findExecutable(String exec) {
        return Executable.findExecutable((String)exec);
    }

    public static File findExecutable(String name, String errorMessage, OutputOptionMixin output) {
        return Executable.findExecutable((String)name, (String)errorMessage, (MessageWriter)output);
    }

    public static int executeProcess(OutputOptionMixin output, String[] args, File parentDir) throws IOException, InterruptedException {
        if (output.isVerbose()) {
            output.out().println(String.join((CharSequence)" ", args));
            output.out().println();
        }
        int exit = 1;
        if (output.isCliTest()) {
            Process process = new ProcessBuilder(new String[0]).command(args).redirectInput(ProcessBuilder.Redirect.INHERIT).directory(parentDir).start();
            ExecutorService service = Executors.newFixedThreadPool(2);
            service.submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(output.out()::println));
            service.submit(() -> new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().forEach(output.err()::println));
            process.waitFor(5L, TimeUnit.MINUTES);
            service.shutdown();
            exit = process.exitValue();
        } else {
            Process process = new ProcessBuilder(new String[0]).command(args).inheritIO().directory(parentDir).start();
            exit = process.waitFor();
        }
        if (exit != 0) {
            return 1;
        }
        return 0;
    }

    public static File findWrapper(Path projectRoot, String[] windows, String other) {
        return Executable.findWrapper((Path)projectRoot, (String[])windows, (String)other);
    }
}

