/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class CacheAnnotationsTransformer
implements AnnotationsTransformer {
    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.METHOD;
    }

    public void transform(AnnotationsTransformer.TransformationContext context) {
        MethodInfo method = context.getTarget().asMethod();
        if (this.requiresCacheKeyParameterPositionsInterceptorBinding(method)) {
            ArrayList<AnnotationValue> positions = new ArrayList<AnnotationValue>();
            for (AnnotationInstance annotation : method.annotations(CacheDeploymentConstants.CACHE_KEY)) {
                positions.add(AnnotationValue.createShortValue((String)"", (short)annotation.target().asMethodParameter().position()));
            }
            if (!positions.isEmpty()) {
                AnnotationValue annotationValue = AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])this.toArray(positions));
                AnnotationInstance binding = AnnotationInstance.create((DotName)CacheDeploymentConstants.CACHE_KEY_PARAMETER_POSITIONS, (AnnotationTarget)method, (AnnotationValue[])new AnnotationValue[]{annotationValue});
                context.transform().add(binding).done();
            }
        }
    }

    private boolean requiresCacheKeyParameterPositionsInterceptorBinding(MethodInfo method) {
        return method.hasAnnotation(CacheDeploymentConstants.CACHE_KEY) && (method.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE) || method.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_LIST) || method.hasAnnotation(CacheDeploymentConstants.CACHE_RESULT));
    }

    private AnnotationValue[] toArray(List<AnnotationValue> parameters) {
        return parameters.toArray(new AnnotationValue[0]);
    }
}

