/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.resolver.maven.workspace.WorkspaceLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class WorkspaceModulePom {
    final Path pom;
    Model model;
    Model effectiveModel;
    WorkspaceModulePom parent;
    boolean processed;

    WorkspaceModulePom(Path pom) {
        this(pom, null, null);
    }

    public WorkspaceModulePom(Path pom, Model model, Model effectiveModel) {
        this.pom = pom.normalize().toAbsolutePath();
        this.model = model;
        this.effectiveModel = effectiveModel;
    }

    Path getModuleDir() {
        Path moduleDir = this.pom.getParent();
        return moduleDir == null ? WorkspaceLoader.getFsRootDir() : moduleDir;
    }

    Model getModel() {
        return this.model == null ? (this.model = WorkspaceLoader.readModel(this.pom)) : this.model;
    }

    Path getParentPom() {
        if (this.model == null) {
            return null;
        }
        Path parentPom = null;
        Parent parent = this.model.getParent();
        if (parent != null && parent.getRelativePath() != null && !parent.getRelativePath().isEmpty()) {
            parentPom = this.pom.getParent().resolve(parent.getRelativePath()).normalize();
            if (Files.isDirectory(parentPom, new LinkOption[0])) {
                parentPom = parentPom.resolve("pom.xml");
            }
        } else {
            Path parentDir = this.pom.getParent().getParent();
            if (parentDir != null) {
                parentPom = parentDir.resolve("pom.xml");
            }
        }
        return parentPom != null && Files.exists(parentPom, new LinkOption[0]) ? parentPom : null;
    }

    void process(Consumer<WorkspaceModulePom> consumer) {
        if (this.processed) {
            return;
        }
        this.processed = true;
        if (this.parent != null) {
            this.parent.process(consumer);
        }
        if (this.model != null && this.model != WorkspaceLoader.MISSING_MODEL) {
            consumer.accept(this);
        }
    }

    public String toString() {
        return String.valueOf(this.pom);
    }
}

