/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.maven.workspace.ProjectModuleResolver;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;

public class LocalWorkspace
implements WorkspaceModelResolver,
WorkspaceReader,
ProjectModuleResolver {
    private final Map<ArtifactKey, LocalProject> projects = new HashMap<ArtifactKey, LocalProject>();
    private final WorkspaceRepository wsRepo = new WorkspaceRepository();
    private ArtifactKey lastFindVersionsKey;
    private List<String> lastFindVersions;
    private volatile long lastModified = -1L;
    private volatile int id = -1;
    private String resolvedVersion;
    private BootstrapMavenContext mvnCtx;
    private LocalProject currentProject;

    protected void addProject(LocalProject project) {
        this.projects.put(project.getKey(), project);
    }

    public LocalProject getProject(String groupId, String artifactId) {
        return this.getProject(ArtifactKey.ga((String)groupId, (String)artifactId));
    }

    public LocalProject getProject(ArtifactKey key) {
        return this.projects.get(key);
    }

    public long getLastModified() {
        if (this.lastModified < 0L) {
            this.initLastModifiedAndHash();
        }
        return this.lastModified;
    }

    public int getId() {
        if (this.id < 0) {
            this.initLastModifiedAndHash();
        }
        return this.id;
    }

    private void initLastModifiedAndHash() {
        long lastModified = 0L;
        int[] hashes = new int[this.projects.size()];
        int i = 0;
        for (LocalProject project : this.projects.values()) {
            lastModified = Math.max(project.getPomLastModified(), lastModified);
            hashes[i++] = project.getKey().hashCode();
        }
        Arrays.sort(hashes);
        this.id = Arrays.hashCode(hashes);
        this.lastModified = lastModified;
    }

    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) {
        LocalProject lp = this.getLocalProjectOrNull(groupId, artifactId, versionConstraint);
        return lp == null ? null : lp.getRawModel();
    }

    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) {
        LocalProject lp = this.getLocalProjectOrNull(groupId, artifactId, versionConstraint);
        return lp == null ? null : lp.getEffectiveModel();
    }

    public Map<ArtifactKey, LocalProject> getProjects() {
        return this.projects;
    }

    public WorkspaceRepository getRepository() {
        return this.wsRepo;
    }

    public File findArtifact(Artifact artifact) {
        File pom;
        LocalProject lp = this.getLocalProjectOrNull(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (lp == null) {
            return null;
        }
        if ("pom".equals(artifact.getExtension()) && (pom = lp.getRawModel().getPomFile()).exists() && ("pom".equals(lp.getRawModel().getPackaging()) || this.mvnCtx != null && this.mvnCtx.isPreferPomsFromWorkspace() || Files.exists(lp.getOutputDir(), new LinkOption[0]) || this.emptyJarOutput(lp, artifact) != null)) {
            return pom;
        }
        Path path = lp.getOutputDir().resolve(LocalWorkspace.getFileName(artifact));
        if (Files.exists(path, new LinkOption[0])) {
            return path.toFile();
        }
        if ("tests".equals(artifact.getClassifier()) && Files.exists(path = lp.getTestClassesDir(), new LinkOption[0])) {
            return path.toFile();
        }
        if ("jar".equals(artifact.getExtension())) {
            path = lp.getClassesDir();
            if (Files.exists(path, new LinkOption[0])) {
                return path.toFile();
            }
            path = this.emptyJarOutput(lp, artifact);
            if (path != null) {
                return path.toFile();
            }
        }
        return null;
    }

    public LocalProject getLocalProjectOrNull(String groupId, String artifactId, String version) {
        LocalProject lp = this.getProject(groupId, artifactId);
        if (!(lp != null && (version.isEmpty() || lp.getVersion().equals(version) || ModelUtils.isUnresolvedVersion(version) && lp.getVersion().equals(this.resolvedVersion)))) {
            return null;
        }
        return lp;
    }

    private Path emptyJarOutput(LocalProject lp, Artifact artifact) {
        if (!Files.exists(lp.getSourcesSourcesDir(), new LinkOption[0]) && lp.getResourcesSourcesDirs().stream().noneMatch(x$0 -> Files.exists(x$0, new LinkOption[0])) && !this.isFoundInLocalRepo(artifact)) {
            try {
                Path classesDir = lp.getClassesDir();
                Files.createDirectories(classesDir, new FileAttribute[0]);
                return classesDir;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isFoundInLocalRepo(Artifact artifact) {
        String localRepo = this.getLocalRepo();
        if (localRepo == null) {
            return false;
        }
        Path p = Paths.get(localRepo, new String[0]);
        for (String s : artifact.getGroupId().split("\\.")) {
            p = p.resolve(s);
        }
        p = p.resolve(artifact.getArtifactId());
        p = p.resolve(artifact.getVersion());
        p = p.resolve(LocalWorkspace.getFileName(artifact));
        return Files.exists(p, new LinkOption[0]);
    }

    public static String getFileName(Artifact artifact) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (!artifact.getClassifier().isEmpty()) {
            fileName.append('-').append(artifact.getClassifier());
        }
        fileName.append('.').append(artifact.getExtension());
        return fileName.toString();
    }

    private String getLocalRepo() {
        try {
            return (this.mvnCtx == null ? (this.mvnCtx = new BootstrapMavenContext((BootstrapMavenContextConfig<?>)BootstrapMavenContext.config().setCurrentProject(this.currentProject))) : this.mvnCtx).getLocalRepo();
        }
        catch (BootstrapMavenException e) {
            return null;
        }
    }

    public List<String> findVersions(Artifact artifact) {
        if (this.lastFindVersionsKey != null && this.lastFindVersionsKey.getArtifactId().equals(artifact.getArtifactId()) && artifact.getVersion().equals(this.lastFindVersions.get(0)) && this.lastFindVersionsKey.getGroupId().equals(artifact.getGroupId())) {
            return this.lastFindVersions;
        }
        if (this.findArtifact(artifact) == null) {
            return List.of();
        }
        this.lastFindVersionsKey = ArtifactKey.ga((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        this.lastFindVersions = List.of(artifact.getVersion());
        return this.lastFindVersions;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    void setResolvedVersion(String resolvedVersion) {
        this.resolvedVersion = resolvedVersion;
    }

    void setBootstrapMavenContext(BootstrapMavenContext mvnCtx) {
        this.mvnCtx = mvnCtx;
    }

    @Override
    public WorkspaceModule getProjectModule(String groupId, String artifactId, String version) {
        LocalProject project = this.getLocalProjectOrNull(groupId, artifactId, version);
        return project == null ? null : project.toWorkspaceModule(this.mvnCtx);
    }
}

