/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersion;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersionConstraint;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.DependencyLoggingConfig;
import io.quarkus.bootstrap.resolver.maven.DependencyTreeConflictResolver;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.ExtensionInfo;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;
import io.quarkus.bootstrap.resolver.maven.OrderedDependencyVisitor;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiConsumer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.jboss.logging.Logger;

public class ApplicationDependencyResolver {
    private static final Logger log = Logger.getLogger(ApplicationDependencyResolver.class);
    private static final String QUARKUS_RUNTIME_ARTIFACT = "quarkus.runtime";
    private static final String QUARKUS_EXTENSION_DEPENDENCY = "quarkus.ext";
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;
    private static final byte COLLECT_DEPLOYMENT_INJECTION_POINTS = 8;
    private static final boolean BLOCKING_TASK_RUNNER = Boolean.getBoolean("quarkus.bootstrap.blocking-task-runner");
    private final ExtensionInfo EXT_INFO_NONE = new ExtensionInfo();
    private List<AppDep> deploymentInjectionPoints = new ArrayList<AppDep>();
    private final Map<ArtifactKey, ExtensionInfo> allExtensions = new ConcurrentHashMap<ArtifactKey, ExtensionInfo>();
    private Collection<ConditionalDependency> conditionalDepsToProcess = new ConcurrentLinkedDeque<ConditionalDependency>();
    private MavenArtifactResolver resolver;
    private List<Dependency> managedDeps;
    private ApplicationModelBuilder appBuilder;
    private boolean collectReloadableModules;
    private DependencyLoggingConfig depLogging;
    private List<Dependency> collectCompileOnly;
    private boolean runtimeModelOnly;
    private boolean devMode;

    public static ApplicationDependencyResolver newInstance() {
        return new ApplicationDependencyResolver();
    }

    private static ModelResolutionTaskRunner getTaskRunner() {
        return BLOCKING_TASK_RUNNER ? ModelResolutionTaskRunner.getBlockingTaskRunner() : ModelResolutionTaskRunner.getNonBlockingTaskRunner();
    }

    public ApplicationDependencyResolver setArtifactResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ApplicationDependencyResolver setApplicationModelBuilder(ApplicationModelBuilder appBuilder) {
        this.appBuilder = appBuilder;
        return this;
    }

    public ApplicationDependencyResolver setCollectReloadableModules(boolean collectReloadableModules) {
        this.collectReloadableModules = collectReloadableModules;
        return this;
    }

    public ApplicationDependencyResolver setDependencyLogging(DependencyLoggingConfig depLogging) {
        this.depLogging = depLogging;
        return this;
    }

    public ApplicationDependencyResolver setCollectCompileOnly(List<Dependency> collectCompileOnly) {
        this.collectCompileOnly = collectCompileOnly;
        return this;
    }

    public ApplicationDependencyResolver setRuntimeModelOnly(boolean runtimeModelOnly) {
        this.runtimeModelOnly = runtimeModelOnly;
        return this;
    }

    public ApplicationDependencyResolver setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public void resolve(CollectRequest collectRtDepsRequest) throws AppModelResolverException {
        this.managedDeps = collectRtDepsRequest.getManagedDependencies();
        this.collectPlatformProperties();
        this.managedDeps = this.managedDeps.isEmpty() ? new ArrayList() : this.managedDeps;
        DependencyNode root = this.resolveRuntimeDeps(collectRtDepsRequest);
        this.processRuntimeDeps(root);
        this.activateConditionalDeps();
        if (!this.runtimeModelOnly) {
            this.injectDeploymentDeps();
        }
        DependencyTreeConflictResolver.resolveConflicts(root);
        this.populateModelBuilder(root);
        for (ResolvedDependencyBuilder d : this.appBuilder.getDependencies()) {
            if (d.isFlagSet(64) || d.isFlagSet(2048)) continue;
            this.clearReloadableFlag(d);
        }
        for (ResolvedDependencyBuilder d : this.appBuilder.getDependencies()) {
            d.clearFlag(2048);
            if (d.isFlagSet(64)) {
                this.appBuilder.addReloadableWorkspaceModule(d.getKey());
            }
            if (this.runtimeModelOnly) continue;
            d.setFlags(8);
        }
        if (!this.runtimeModelOnly) {
            this.collectCompileOnly(collectRtDepsRequest, root);
        }
    }

    private void activateConditionalDeps() {
        if (this.conditionalDepsToProcess.isEmpty()) {
            return;
        }
        boolean checkDependencyConditions = true;
        while (!this.conditionalDepsToProcess.isEmpty() && checkDependencyConditions) {
            checkDependencyConditions = false;
            Collection<ConditionalDependency> unsatisfiedConditionalDeps = this.conditionalDepsToProcess;
            this.conditionalDepsToProcess = new ConcurrentLinkedDeque<ConditionalDependency>();
            for (ConditionalDependency cd : unsatisfiedConditionalDeps) {
                if (cd.isSatisfied()) {
                    cd.activate();
                    checkDependencyConditions = true;
                    continue;
                }
                this.conditionalDepsToProcess.add(cd);
            }
        }
        this.conditionalDepsToProcess = List.of();
    }

    private void populateModelBuilder(DependencyNode root) {
        AppDep app = new AppDep(root);
        this.initMissingDependencies(app);
        this.appBuilder.getApplicationArtifact().addDependencies(app.allDeps);
        for (AppDep d : app.children) {
            d.addToModel();
        }
        if (this.depLogging != null) {
            new AppDepLogger().log(app);
        }
    }

    private void initMissingDependencies(AppDep app) {
        ModelResolutionTaskRunner taskRunner = ApplicationDependencyResolver.getTaskRunner();
        app.scheduleChildVisits(taskRunner, AppDep::initMissingDependencies);
        taskRunner.waitForCompletion();
    }

    private void injectDeploymentDeps() {
        for (AppDep dep : this.collectDeploymentDeps()) {
            dep.injectDeploymentDependency();
        }
    }

    private Collection<AppDep> collectDeploymentDeps() {
        ConcurrentLinkedDeque<AppDep> injectQueue = new ConcurrentLinkedDeque<AppDep>();
        ModelResolutionTaskRunner taskRunner = this.deploymentInjectionPoints.size() == 1 ? ModelResolutionTaskRunner.getBlockingTaskRunner() : ApplicationDependencyResolver.getTaskRunner();
        for (AppDep extDep : this.deploymentInjectionPoints) {
            extDep.scheduleCollectDeploymentDeps(taskRunner, injectQueue);
        }
        this.deploymentInjectionPoints = List.of();
        taskRunner.waitForCompletion();
        return injectQueue;
    }

    private void collectCompileOnly(CollectRequest collectRtDepsRequest, DependencyNode root) throws BootstrapMavenException {
        if (this.collectCompileOnly.isEmpty()) {
            return;
        }
        ArrayDeque<List> depStack = new ArrayDeque<List>();
        List children = root.getChildren();
        while (children != null) {
            for (DependencyNode node : children) {
                this.managedDeps.add(node.getDependency());
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            children = (List)depStack.poll();
        }
        CollectRequest request = new CollectRequest().setDependencies(this.collectCompileOnly).setManagedDependencies(this.managedDeps).setRepositories(collectRtDepsRequest.getRepositories());
        if (collectRtDepsRequest.getRoot() != null) {
            request.setRoot(collectRtDepsRequest.getRoot());
        } else {
            request.setRootArtifact(collectRtDepsRequest.getRootArtifact());
        }
        try {
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapDependencyProcessingException("Failed to collect compile-only dependencies of " + String.valueOf(root.getArtifact()), e);
        }
        children = root.getChildren();
        int flags = 4098;
        while (children != null) {
            for (DependencyNode node : children) {
                if (DependencyUtils.hasWinner(node)) continue;
                ExtensionInfo extInfo = this.getExtensionInfoOrNull(node.getArtifact(), node.getRepositories());
                ResolvedDependencyBuilder dep = this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact()));
                if (dep == null) {
                    dep = (ResolvedDependencyBuilder)DependencyUtils.newDependencyBuilder(node, this.resolver).setFlags(flags);
                    if (extInfo != null) {
                        dep.setFlags(16);
                        if (dep.isFlagSet(2)) {
                            dep.setFlags(128);
                        }
                    }
                    this.appBuilder.addDependency(dep);
                } else {
                    dep.setFlags(4096);
                }
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            flags = 4096;
            children = (List)depStack.poll();
        }
    }

    private void collectPlatformProperties() throws AppModelResolverException {
        PlatformImportsImpl platformReleases = new PlatformImportsImpl();
        for (Dependency d : this.managedDeps) {
            Artifact artifact = d.getArtifact();
            String extension = artifact.getExtension();
            if ("json".equals(extension) && artifact.getArtifactId().endsWith("-quarkus-platform-descriptor")) {
                platformReleases.addPlatformDescriptor(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), extension, artifact.getVersion());
                continue;
            }
            if (!"properties".equals(extension) || !artifact.getArtifactId().endsWith("-quarkus-platform-properties")) continue;
            platformReleases.addPlatformProperties(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), extension, artifact.getVersion(), this.resolver.resolve(artifact).getArtifact().getFile().toPath());
        }
        this.appBuilder.setPlatformImports((PlatformImports)platformReleases);
    }

    private void clearReloadableFlag(ResolvedDependencyBuilder dep) {
        Collection deps = dep.getDependencies();
        if (deps.isEmpty()) {
            return;
        }
        for (ArtifactCoords coords : deps) {
            ResolvedDependencyBuilder child = this.appBuilder.getDependency(coords.getKey());
            if (child == null || child.isFlagSet(2048)) continue;
            child.setFlags(2048);
            child.clearFlag(64);
            this.clearReloadableFlag(child);
        }
    }

    private DependencyNode resolveRuntimeDeps(CollectRequest request) throws AppModelResolverException {
        boolean verbose = true;
        if (verbose) {
            RepositorySystemSession session = this.resolver.getSession();
            DefaultRepositorySystemSession mutableSession = new DefaultRepositorySystemSession(this.resolver.getSession());
            mutableSession.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
            mutableSession.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            session = mutableSession;
            BootstrapMavenContext ctx = new BootstrapMavenContext((BootstrapMavenContextConfig<?>)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)BootstrapMavenContext.config().setRepositorySystem(this.resolver.getSystem())).setRepositorySystemSession(session)).setRemoteRepositories(this.resolver.getRepositories())).setRemoteRepositoryManager(this.resolver.getRemoteRepositoryManager())).setCurrentProject(this.resolver.getMavenContext().getCurrentProject())).setWorkspaceDiscovery(this.resolver.getMavenContext().getCurrentProject() != null));
            this.resolver = new MavenArtifactResolver(ctx);
        }
        try {
            return this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            Artifact a = request.getRoot() == null ? request.getRootArtifact() : request.getRoot().getArtifact();
            throw new BootstrapMavenException("Failed to resolve dependencies for " + String.valueOf(a), e);
        }
    }

    private boolean isRuntimeArtifact(ArtifactKey key) {
        ResolvedDependencyBuilder dep = this.appBuilder.getDependency(key);
        return dep != null && dep.isFlagSet(4);
    }

    private void processRuntimeDeps(DependencyNode root) {
        AppDep appRoot = new AppDep(root);
        this.visitRuntimeDeps(appRoot);
        this.appBuilder.getApplicationArtifact().addDependencies(appRoot.allDeps);
        appRoot.setChildFlags((byte)(0xB | (this.collectReloadableModules ? 4 : 0)));
    }

    private void visitRuntimeDeps(AppDep appRoot) {
        ModelResolutionTaskRunner taskRunner = ApplicationDependencyResolver.getTaskRunner();
        appRoot.scheduleChildVisits(taskRunner, AppDep::scheduleRuntimeVisit);
        taskRunner.waitForCompletion();
    }

    private static byte clearFlag(byte flags, byte flag) {
        return (flags & flag) > 0 ? (byte)(flags ^ flag) : flags;
    }

    private static boolean isFlagOn(byte flags, byte flag) {
        return (flags & flag) > 0;
    }

    private ExtensionInfo getExtensionInfoOrNull(Artifact artifact, List<RemoteRepository> repos) throws BootstrapDependencyProcessingException {
        if (!artifact.getExtension().equals("jar")) {
            return null;
        }
        ArtifactKey extKey = DependencyUtils.getKey(artifact);
        ExtensionInfo ext = this.allExtensions.get(extKey);
        if (ext != null) {
            return ext == this.EXT_INFO_NONE ? null : ext;
        }
        Path path = (artifact = this.resolve(artifact, repos)).getFile().toPath();
        Properties descriptor = (Properties)PathTree.ofDirectoryOrArchive((Path)path).apply("META-INF/quarkus-extension.properties", ApplicationDependencyResolver::readExtensionProperties);
        if (descriptor == null) {
            this.allExtensions.put(extKey, this.EXT_INFO_NONE);
            return null;
        }
        ext = new ExtensionInfo(artifact, descriptor, this.devMode);
        this.allExtensions.put(extKey, ext);
        return ext;
    }

    private static Properties readExtensionProperties(PathVisit visit) {
        if (visit == null) {
            return null;
        }
        try {
            Properties rtProps = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                rtProps.load(reader);
            }
            return rtProps;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private DependencyNode collectDependencies(Artifact artifact, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        DependencyNode root;
        try {
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), this.getCollectRequest(artifact, exclusions, repos)).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new DeploymentInjectionException("Failed to collect dependencies for " + String.valueOf(artifact), e);
        }
        if (root.getChildren().size() != 1) {
            throw new DeploymentInjectionException("Only one child expected but got " + String.valueOf(root.getChildren()));
        }
        return (DependencyNode)root.getChildren().get(0);
    }

    private CollectRequest getCollectRequest(Artifact artifact, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        ArtifactDescriptorResult descr;
        try {
            descr = this.resolver.resolveDescriptor(artifact, repos);
        }
        catch (BootstrapMavenException e) {
            throw new DeploymentInjectionException("Failed to resolve descriptor for " + String.valueOf(artifact), (Throwable)((Object)e));
        }
        ArrayList<Dependency> allConstraints = new ArrayList<Dependency>(this.managedDeps.size() + descr.getManagedDependencies().size());
        allConstraints.addAll(this.managedDeps);
        allConstraints.addAll(descr.getManagedDependencies());
        return new CollectRequest().setManagedDependencies(allConstraints).setRepositories(repos).setRootArtifact(artifact).setDependencies(List.of(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions)));
    }

    private Artifact resolve(Artifact artifact, List<RemoteRepository> repos) {
        if (artifact.getFile() != null) {
            return artifact;
        }
        try {
            return this.resolver.getSystem().resolveArtifact(this.resolver.getSession(), new ArtifactRequest().setArtifact(artifact).setRepositories(repos)).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new DeploymentInjectionException("Failed to resolve artifact " + String.valueOf(artifact), e);
        }
    }

    private static void ensureScopeAndOptionality(DependencyNode node, String scope, boolean optional) {
        Dependency dep = node.getDependency();
        if (optional == dep.isOptional() && scope.equals(dep.getScope())) {
            return;
        }
        OrderedDependencyVisitor visitor = new OrderedDependencyVisitor(node);
        while (visitor.hasNext()) {
            dep = visitor.next().getDependency();
            if (optional != dep.isOptional()) {
                visitor.getCurrent().setOptional(Boolean.valueOf(optional));
            }
            if (scope.equals(dep.getScope())) continue;
            visitor.getCurrent().setScope(scope);
        }
    }

    private static boolean isSameKey(Artifact a1, Artifact a2) {
        return a2.getArtifactId().equals(a1.getArtifactId()) && a2.getGroupId().equals(a1.getGroupId()) && a2.getClassifier().equals(a1.getClassifier()) && a2.getExtension().equals(a1.getExtension());
    }

    private class ConditionalDependency {
        final AppDep conditionalDep;
        private boolean activated;

        private ConditionalDependency(Artifact artifact, ExtensionInfo info, AppDep parent) {
            DefaultDependencyNode rtNode = new DefaultDependencyNode(new Dependency(artifact, "compile"));
            rtNode.setVersion((Version)new BootstrapArtifactVersion(artifact.getVersion()));
            rtNode.setVersionConstraint((VersionConstraint)new BootstrapArtifactVersionConstraint(new BootstrapArtifactVersion(artifact.getVersion())));
            rtNode.setRepositories(parent.ext.runtimeNode.getRepositories());
            this.conditionalDep = new AppDep(parent, (DependencyNode)rtNode);
            this.conditionalDep.ext = info == null ? null : new ExtensionDependency(info, (DependencyNode)rtNode, parent.ext.exclusions);
        }

        void activate() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            AppDep parent = this.conditionalDep.parent;
            DependencyNode originalNode = ApplicationDependencyResolver.this.collectDependencies(this.conditionalDep.node.getArtifact(), parent.ext.exclusions, parent.node.getRepositories());
            ApplicationDependencyResolver.ensureScopeAndOptionality(originalNode, parent.ext.runtimeNode.getDependency().getScope(), parent.ext.runtimeNode.getDependency().isOptional());
            DefaultDependencyNode rtNode = (DefaultDependencyNode)this.conditionalDep.node;
            rtNode.setRepositories(originalNode.getRepositories());
            List currentChildren = rtNode.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                rtNode.setChildren(originalNode.getChildren());
            } else {
                currentChildren.addAll(originalNode.getChildren());
            }
            if (this.conditionalDep.ext != null && this.conditionalDep.ext.extDeps == null) {
                this.conditionalDep.ext.extDeps = new ArrayList<ExtensionDependency>();
            }
            this.visitRuntimeDeps();
            this.conditionalDep.setFlags((byte)(8 | (ApplicationDependencyResolver.this.collectReloadableModules ? 4 : 0)));
            if (parent.resolvedDep != null) {
                parent.resolvedDep.addDependency(this.conditionalDep.resolvedDep.getArtifactCoords());
            }
            parent.ext.runtimeNode.getChildren().add(rtNode);
        }

        private void visitRuntimeDeps() {
            ModelResolutionTaskRunner taskRunner = ApplicationDependencyResolver.getTaskRunner();
            this.conditionalDep.scheduleRuntimeVisit(taskRunner);
            taskRunner.waitForCompletion();
        }

        boolean isSatisfied() {
            ExtensionInfo extInfo;
            ExtensionInfo extensionInfo = extInfo = this.conditionalDep.ext == null ? null : this.conditionalDep.ext.info;
            if (extInfo == null || extInfo.dependencyCondition == null) {
                return true;
            }
            for (ArtifactKey key : extInfo.dependencyCondition) {
                if (ApplicationDependencyResolver.this.isRuntimeArtifact(key)) continue;
                return false;
            }
            return true;
        }
    }

    private class AppDep {
        final AppDep parent;
        final DependencyNode node;
        ExtensionDependency ext;
        ResolvedDependencyBuilder resolvedDep;
        final List<AppDep> children;
        final List<ArtifactCoords> allDeps;

        AppDep(DependencyNode node) {
            this.parent = null;
            this.node = node;
            this.children = new ArrayList<AppDep>(node.getChildren().size());
            this.allDeps = new ArrayList<ArtifactCoords>(node.getChildren().size());
        }

        AppDep(AppDep parent, DependencyNode node) {
            this.parent = parent;
            this.node = node;
            this.children = new ArrayList<AppDep>(node.getChildren().size());
            this.allDeps = new ArrayList<ArtifactCoords>(node.getChildren().size());
        }

        void addToModel() {
            for (AppDep child : this.children) {
                child.addToModel();
            }
            if (this.resolvedDep != null) {
                this.resolvedDep.addDependencies(this.allDeps);
                ApplicationDependencyResolver.this.appBuilder.addDependency(this.resolvedDep);
            }
        }

        void initMissingDependencies(ModelResolutionTaskRunner taskRunner) {
            if (this.resolvedDep == null && !ApplicationDependencyResolver.this.appBuilder.hasDependency(DependencyUtils.getKey(this.node.getArtifact()))) {
                taskRunner.run(this::initResolvedDependency);
            }
            this.scheduleChildVisits(taskRunner, AppDep::initMissingDependencies);
        }

        void initResolvedDependency() {
            try {
                this.resolvedDep = DependencyUtils.newDependencyBuilder(this.node, ApplicationDependencyResolver.this.resolver);
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        void scheduleRuntimeVisit(ModelResolutionTaskRunner taskRunner) {
            taskRunner.run(this::visitRuntimeDependency);
            this.scheduleChildVisits(taskRunner, AppDep::scheduleRuntimeVisit);
        }

        void visitRuntimeDependency() {
            Artifact artifact = this.node.getArtifact();
            if (this.resolvedDep == null) {
                this.resolvedDep = ApplicationDependencyResolver.this.appBuilder.getDependency(DependencyUtils.getKey(artifact));
            }
            if (!this.node.getRelocations().isEmpty()) {
                ((DefaultDependencyNode)this.node).setRelocations(List.of());
            }
            if (this.resolvedDep == null) {
                WorkspaceModule module = null;
                if (ApplicationDependencyResolver.this.resolver.getProjectModuleResolver() != null) {
                    module = ApplicationDependencyResolver.this.resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                }
                try {
                    ExtensionDependency ext;
                    this.resolvedDep = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(this.getResolvedArtifact(), module).setOptional(this.node.getDependency().isOptional())).setScope(this.node.getDependency().getScope())).setFlags(12);
                    if ("provided".equals(this.resolvedDep.getScope())) {
                        this.resolvedDep.setFlags(4096);
                    }
                    if ((ext = this.getExtensionDependencyOrNull()) != null) {
                        this.resolvedDep.setRuntimeExtensionArtifact();
                        this.collectConditionalDependencies();
                    }
                }
                catch (DeploymentInjectionException e) {
                    throw e;
                }
                catch (Exception t) {
                    throw new DeploymentInjectionException("Failed to inject extension deployment dependencies", t);
                }
            }
        }

        void scheduleChildVisits(ModelResolutionTaskRunner taskRunner, BiConsumer<AppDep, ModelResolutionTaskRunner> childVisitor) {
            this.filterChildren();
            for (AppDep child : this.children) {
                childVisitor.accept(child, taskRunner);
            }
        }

        private void filterChildren() {
            List childNodes = this.node.getChildren();
            ArrayList<DependencyNode> filtered = null;
            for (int i = 0; i < childNodes.size(); ++i) {
                DependencyNode childNode = (DependencyNode)childNodes.get(i);
                DependencyNode winner = DependencyUtils.getWinner(childNode);
                if (winner == null) {
                    this.allDeps.add(DependencyUtils.getCoords(childNode.getArtifact()));
                    this.children.add(new AppDep(this, childNode));
                    if (filtered == null) continue;
                    filtered.add(childNode);
                    continue;
                }
                this.allDeps.add(DependencyUtils.getCoords(winner.getArtifact()));
                if (filtered != null) continue;
                filtered = new ArrayList<DependencyNode>(childNodes.size());
                for (int j = 0; j < i; ++j) {
                    filtered.add((DependencyNode)childNodes.get(j));
                }
            }
            if (filtered != null) {
                this.node.setChildren(filtered);
            }
        }

        void setChildFlags(byte walkingFlags) {
            for (AppDep c : this.children) {
                c.setFlags(walkingFlags);
            }
        }

        void setFlags(byte walkingFlags) {
            this.resolvedDep.addDependencies(this.allDeps);
            ResolvedDependencyBuilder existingDep = ApplicationDependencyResolver.this.appBuilder.getDependency(this.resolvedDep.getKey());
            if (existingDep == null) {
                ApplicationDependencyResolver.this.appBuilder.addDependency(this.resolvedDep);
                if (this.ext != null) {
                    ApplicationDependencyResolver.this.managedDeps.add(new Dependency(this.ext.info.deploymentArtifact, "compile"));
                }
            } else if (existingDep != this.resolvedDep) {
                throw new IllegalStateException(String.valueOf(this.node.getArtifact()) + " is already present in the application model");
            }
            this.resolvedDep.setDirect(ApplicationDependencyResolver.isFlagOn(walkingFlags, (byte)2));
            if (this.ext != null) {
                this.ext.info.ensureActivated(ApplicationDependencyResolver.this.appBuilder);
                if (ApplicationDependencyResolver.isFlagOn(walkingFlags, (byte)1)) {
                    walkingFlags = ApplicationDependencyResolver.clearFlag(walkingFlags, (byte)1);
                    this.resolvedDep.setFlags(128);
                }
                if (ApplicationDependencyResolver.isFlagOn(walkingFlags, (byte)8)) {
                    walkingFlags = ApplicationDependencyResolver.clearFlag(walkingFlags, (byte)8);
                    this.ext.extDeps = new ArrayList<ExtensionDependency>();
                    ApplicationDependencyResolver.this.deploymentInjectionPoints.add(this);
                } else if (!this.ext.presentInTargetGraph) {
                    AppDep parentExtDep = this.parent;
                    while (parentExtDep != null) {
                        if (parentExtDep.ext != null && parentExtDep.ext.extDeps != null) {
                            parentExtDep.ext.addExtensionDependency(this.ext);
                            break;
                        }
                        parentExtDep = parentExtDep.parent;
                    }
                }
                this.ext.info.ensureActivated(ApplicationDependencyResolver.this.appBuilder);
            }
            if (ApplicationDependencyResolver.isFlagOn(walkingFlags, (byte)4)) {
                if (this.resolvedDep.getWorkspaceModule() != null && !this.resolvedDep.isFlagSet(16)) {
                    this.resolvedDep.setReloadable();
                } else {
                    walkingFlags = ApplicationDependencyResolver.clearFlag(walkingFlags, (byte)4);
                }
            }
            walkingFlags = ApplicationDependencyResolver.clearFlag(walkingFlags, (byte)2);
            this.setChildFlags(walkingFlags);
        }

        private ExtensionDependency getExtensionDependencyOrNull() throws BootstrapDependencyProcessingException {
            ExtensionInfo extInfo;
            if (this.ext != null) {
                return this.ext;
            }
            this.ext = ExtensionDependency.get(this.node);
            if (this.ext == null && (extInfo = ApplicationDependencyResolver.this.getExtensionInfoOrNull(this.node.getArtifact(), this.node.getRepositories())) != null) {
                this.ext = new ExtensionDependency(extInfo, this.node, this.collectExclusions());
            }
            return this.ext;
        }

        private Collection<Exclusion> collectExclusions() {
            if (this.parent == null) {
                return List.of();
            }
            ArrayList<Exclusion> exclusions = null;
            AppDep next = this;
            while (next != null) {
                Collection nextExcl;
                if (next.ext != null) {
                    if (exclusions == null) {
                        return next.ext.exclusions;
                    }
                    exclusions.addAll(next.ext.exclusions);
                    return exclusions;
                }
                Collection collection = nextExcl = next.node.getDependency() == null ? null : next.node.getDependency().getExclusions();
                if (nextExcl != null && !nextExcl.isEmpty() && exclusions == null) {
                    exclusions = new ArrayList<Exclusion>(nextExcl);
                }
                next = next.parent;
            }
            return exclusions == null ? List.of() : exclusions;
        }

        Artifact getResolvedArtifact() {
            Artifact result = this.node.getArtifact();
            if (result.getFile() == null) {
                result = ApplicationDependencyResolver.this.resolve(result, this.node.getRepositories());
                this.node.setArtifact(result);
            }
            return result;
        }

        private void collectConditionalDependencies() throws BootstrapDependencyProcessingException {
            if (this.ext == null || this.ext.info.conditionalDeps.length == 0 || this.ext.conditionalDepsQueued) {
                return;
            }
            this.ext.conditionalDepsQueued = true;
            ExclusionDependencySelector selector = this.ext.exclusions == null ? null : new ExclusionDependencySelector(this.ext.exclusions);
            for (Artifact conditionalArtifact : this.ext.info.conditionalDeps) {
                ExtensionInfo condExtInfo;
                if (selector != null && !selector.selectDependency(new Dependency(conditionalArtifact, "runtime")) || (condExtInfo = ApplicationDependencyResolver.this.getExtensionInfoOrNull(conditionalArtifact = ApplicationDependencyResolver.this.resolve(conditionalArtifact, this.ext.runtimeNode.getRepositories()), this.ext.runtimeNode.getRepositories())) != null && condExtInfo.activated) continue;
                ConditionalDependency conditionalDep = new ConditionalDependency(conditionalArtifact, condExtInfo, this);
                ApplicationDependencyResolver.this.conditionalDepsToProcess.add(conditionalDep);
                if (condExtInfo == null) continue;
                conditionalDep.conditionalDep.collectConditionalDependencies();
            }
        }

        private void scheduleCollectDeploymentDeps(ModelResolutionTaskRunner taskRunner, ConcurrentLinkedDeque<AppDep> injectQueue) {
            ResolvedDependencyBuilder resolvedDep = ApplicationDependencyResolver.this.appBuilder.getDependency(DependencyUtils.getKey(this.ext.info.deploymentArtifact));
            if (resolvedDep == null) {
                taskRunner.run(this::collectDeploymentDeps);
                injectQueue.add(this);
            } else {
                resolvedDep.clearFlag(64);
            }
        }

        private void collectDeploymentDeps() {
            this.ext.collectDeploymentDeps();
        }

        private void injectDeploymentDependency() {
            this.ext.injectDependencyDependency(this.parent == null ? null : (this.parent.ext == null ? null : this.parent.ext.deploymentNode));
        }
    }

    private class AppDepLogger {
        final List<Boolean> depth = new ArrayList<Boolean>();

        private AppDepLogger() {
        }

        void log(AppDep dep) {
            this.logInternal(dep);
            int childrenTotal = dep.node.getChildren().size();
            if (childrenTotal > 0) {
                if (childrenTotal == 1) {
                    this.depth.add(false);
                    this.log(dep.children.get(0));
                } else {
                    this.depth.add(true);
                    int i = 0;
                    while (i < childrenTotal) {
                        this.log(dep.children.get(i++));
                        if (i != childrenTotal - 1) continue;
                        this.depth.set(this.depth.size() - 1, false);
                    }
                }
                this.depth.remove(this.depth.size() - 1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void logInternal(AppDep dep) {
            Collection deps;
            StringBuilder buf = new StringBuilder();
            if (!this.depth.isEmpty()) {
                for (int i = 0; i < this.depth.size() - 1; ++i) {
                    if (this.depth.get(i).booleanValue()) {
                        buf.append('\u2502').append("  ");
                        continue;
                    }
                    buf.append("   ");
                }
                if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                    buf.append('\u251c').append('\u2500').append(' ');
                } else {
                    buf.append('\u2514').append('\u2500').append(' ');
                }
            }
            ResolvedDependencyBuilder resolvedDep = this.getResolvedDependency(DependencyUtils.getKey(dep.node.getArtifact()));
            buf.append(resolvedDep.toCompactCoords());
            if (!this.depth.isEmpty()) {
                this.appendFlags(buf, (ResolvedDependency)resolvedDep);
            }
            ApplicationDependencyResolver.this.depLogging.getMessageConsumer().accept(buf.toString());
            if (ApplicationDependencyResolver.this.depLogging.isGraph() && !(deps = resolvedDep.getDependencies()).isEmpty() && deps.size() != dep.children.size()) {
                void var7_11;
                HashMap versions = new HashMap(dep.children.size());
                for (AppDep appDep : dep.children) {
                    versions.put(DependencyUtils.getCoords(appDep.node.getArtifact()), null);
                }
                ArrayList<String> list = new ArrayList<String>(deps.size() - dep.children.size());
                for (ArtifactCoords coords : deps) {
                    if (versions.containsKey(coords)) continue;
                    ResolvedDependencyBuilder childDep = this.getResolvedDependency(coords.getKey());
                    StringBuilder sb = new StringBuilder().append(childDep.toCompactCoords());
                    this.appendFlags(sb, (ResolvedDependency)childDep);
                    list.add(sb.append(" [+]").toString());
                }
                Collections.sort(list);
                boolean bl = false;
                while (var7_11 < list.size()) {
                    buf = new StringBuilder();
                    if (!this.depth.isEmpty()) {
                        for (int i = 0; i < this.depth.size() - 1; ++i) {
                            if (this.depth.get(i).booleanValue()) {
                                buf.append('\u2502').append("  ");
                                continue;
                            }
                            buf.append("   ");
                        }
                        if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                            buf.append('\u2502').append("  ");
                        } else {
                            buf.append("   ");
                        }
                    }
                    if (var7_11 < list.size() - 1) {
                        buf.append('\u251c').append('\u2500').append(' ');
                    } else if (dep.children.isEmpty()) {
                        buf.append('\u2514').append('\u2500').append(' ');
                    } else {
                        buf.append('\u251c').append('\u2500').append(' ');
                    }
                    buf.append((String)list.get((int)var7_11));
                    ApplicationDependencyResolver.this.depLogging.getMessageConsumer().accept(buf.toString());
                    ++var7_11;
                }
            }
        }

        private void appendFlags(StringBuilder sb, ResolvedDependency d) {
            sb.append(" (").append(d.getScope());
            if (d.isFlagSet(1)) {
                sb.append(" optional");
            }
            if (ApplicationDependencyResolver.this.depLogging.isVerbose()) {
                if (d.isFlagSet(4)) {
                    sb.append(", runtime classpath");
                } else {
                    sb.append(", build-time classpath");
                }
                if (d.isFlagSet(16)) {
                    sb.append(", extension");
                }
                if (d.isFlagSet(64)) {
                    sb.append(", reloadable");
                }
            }
            sb.append(')');
        }

        private ResolvedDependencyBuilder getResolvedDependency(ArtifactKey key) {
            ResolvedDependencyBuilder resolvedDep = ApplicationDependencyResolver.this.appBuilder.getDependency(key);
            if (resolvedDep == null) {
                if (ApplicationDependencyResolver.this.appBuilder.getApplicationArtifact().getKey().equals(key)) {
                    return ApplicationDependencyResolver.this.appBuilder.getApplicationArtifact();
                }
                throw new IllegalArgumentException("Failed to locate " + String.valueOf(key) + " among application dependencies");
            }
            return resolvedDep;
        }
    }

    private class ExtensionDependency {
        final ExtensionInfo info;
        final DependencyNode runtimeNode;
        final Collection<Exclusion> exclusions;
        boolean conditionalDepsQueued;
        private List<ExtensionDependency> extDeps;
        private DependencyNode deploymentNode;
        private boolean presentInTargetGraph;

        static ExtensionDependency get(DependencyNode node) {
            return (ExtensionDependency)node.getData().get(ApplicationDependencyResolver.QUARKUS_EXTENSION_DEPENDENCY);
        }

        ExtensionDependency(ExtensionInfo info, DependencyNode node, Collection<Exclusion> exclusions) {
            this.runtimeNode = node;
            this.info = info;
            this.exclusions = exclusions;
            Map data = node.getData();
            if (data.isEmpty()) {
                node.setData((Object)ApplicationDependencyResolver.QUARKUS_EXTENSION_DEPENDENCY, (Object)this);
            } else if (data.put(ApplicationDependencyResolver.QUARKUS_EXTENSION_DEPENDENCY, this) != null) {
                throw new IllegalStateException("Dependency node " + String.valueOf(node) + " has already been associated with an extension dependency");
            }
        }

        void addExtensionDependency(ExtensionDependency dep) {
            if (this.extDeps == null) {
                this.extDeps = new ArrayList<ExtensionDependency>();
            }
            this.extDeps.add(dep);
        }

        private void collectDeploymentDeps() {
            log.debugf("Collecting dependencies of %s", (Object)this.info.deploymentArtifact);
            this.deploymentNode = ApplicationDependencyResolver.this.collectDependencies(this.info.deploymentArtifact, this.exclusions, this.runtimeNode.getRepositories());
            if (this.deploymentNode.getChildren().isEmpty()) {
                throw new RuntimeException("Failed to collect dependencies of " + String.valueOf(this.deploymentNode.getArtifact()) + ": either its POM could not be resolved from the available Maven repositories or the artifact does not have any dependencies while at least a dependency on the runtime artifact " + String.valueOf(this.info.runtimeArtifact) + " is expected");
            }
            ApplicationDependencyResolver.ensureScopeAndOptionality(this.deploymentNode, this.runtimeNode.getDependency().getScope(), this.runtimeNode.getDependency().isOptional());
            this.replaceRuntimeExtensionNodes(this.deploymentNode);
            if (!this.presentInTargetGraph) {
                throw new RuntimeException("Quarkus extension deployment artifact " + String.valueOf(this.deploymentNode.getArtifact()) + " does not appear to depend on the corresponding runtime artifact " + String.valueOf(this.info.runtimeArtifact));
            }
        }

        private void injectDependencyDependency(DependencyNode parentDeploymentNode) {
            if (parentDeploymentNode == null) {
                this.runtimeNode.setData((Object)ApplicationDependencyResolver.QUARKUS_RUNTIME_ARTIFACT, (Object)this.runtimeNode.getArtifact());
                this.runtimeNode.setArtifact(this.deploymentNode.getArtifact());
                this.runtimeNode.setChildren(this.deploymentNode.getChildren());
            } else {
                parentDeploymentNode.getChildren().add(this.deploymentNode);
            }
        }

        void replaceRuntimeExtensionNodes(DependencyNode deploymentNode) {
            int nodesToReplace;
            OrderedDependencyVisitor deploymentVisitor = new OrderedDependencyVisitor(deploymentNode);
            deploymentVisitor.next();
            int n = nodesToReplace = this.extDeps == null ? 1 : this.extDeps.size() + 1;
            block0: while (deploymentVisitor.hasNext() && nodesToReplace > 0) {
                DependencyNode node = deploymentVisitor.next();
                if (DependencyUtils.hasWinner(node)) continue;
                if (this.replaceRuntimeNode(deploymentVisitor)) {
                    --nodesToReplace;
                    continue;
                }
                if (this.extDeps == null) continue;
                for (int i = 0; i < this.extDeps.size(); ++i) {
                    if (!this.extDeps.get(i).replaceRuntimeNode(deploymentVisitor)) continue;
                    --nodesToReplace;
                    continue block0;
                }
            }
        }

        private boolean replaceRuntimeNode(OrderedDependencyVisitor depVisitor) {
            if (!this.presentInTargetGraph && ApplicationDependencyResolver.isSameKey(this.runtimeNode.getArtifact(), depVisitor.getCurrent().getArtifact())) {
                DefaultDependencyNode inserted = new DefaultDependencyNode(this.runtimeNode);
                inserted.setChildren(this.runtimeNode.getChildren());
                depVisitor.replaceCurrent((DependencyNode)inserted);
                this.presentInTargetGraph = true;
                return true;
            }
            return false;
        }
    }
}

