/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.azure.functions.deployment;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import io.quarkus.azure.functions.deployment.AzureFunctionsAppNameBuildItem;
import io.quarkus.azure.functions.deployment.AzureFunctionsConfig;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.cmd.DeployCommandActionBuildItem;
import io.quarkus.deployment.cmd.DeployCommandDeclarationBuildItem;
import io.quarkus.deployment.cmd.DeployConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.logging.Log;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class AzureFunctionsDeployCommand {
    private static final Logger log = Logger.getLogger(AzureFunctionsDeployCommand.class);
    private static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    private static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9._\\-()]{1,90}";
    private static final String APP_SERVICE_PLAN_NAME_PATTERN = "[a-zA-Z0-9\\-]{1,40}";
    private static final String EMPTY_APP_NAME = "Please config the <appName> in pom.xml.";
    private static final String INVALID_APP_NAME = "The app name '%s' is not valid. The <appName> only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.";
    private static final String EMPTY_RESOURCE_GROUP = "Please config the <resourceGroup> in pom.xml.";
    private static final String INVALID_RESOURCE_GROUP_NAME = "The <resourceGroup> only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String INVALID_SERVICE_PLAN_NAME = "Invalid value for <appServicePlanName>, it need to match the pattern %s";
    private static final String INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME = "Invalid value for <appServicePlanResourceGroup>, it only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String EMPTY_IMAGE_NAME = "Please config the <image> of <runtime> in pom.xml.";
    private static final String INVALID_OS = "The value of <os> is not correct, supported values are: windows, linux and docker.";
    private static final String EXPANDABLE_PRICING_TIER_WARNING = "'%s' may not be a valid pricing tier, please refer to https://aka.ms/maven_function_configuration#supported-pricing-tiers for valid values";
    private static final String EXPANDABLE_REGION_WARNING = "'%s' may not be a valid region, please refer to https://aka.ms/maven_function_configuration#supported-regions for valid values";
    private static final String EXPANDABLE_JAVA_VERSION_WARNING = "'%s' may not be a valid java version, recommended values are `Java 17` and `Java 21`";
    protected static final String USING_AZURE_ENVIRONMENT = "Using Azure environment: %s.";
    public static final String AZURE_FUNCTIONS = "azure-functions";
    protected static final String SUBSCRIPTION_TEMPLATE = "Subscription: %s(%s)";
    protected static final String SUBSCRIPTION_NOT_FOUND = "Subscription %s was not found in current account.";
    protected static AzureAppService appServiceClient;
    protected static String subscriptionId;

    @BuildStep
    public void declare(BuildProducer<DeployCommandDeclarationBuildItem> producer) {
        producer.produce((BuildItem)new DeployCommandDeclarationBuildItem(AZURE_FUNCTIONS));
    }

    @BuildStep
    public void deploy(DeployConfig deployConfig, AzureFunctionsConfig config, AzureFunctionsAppNameBuildItem appName, OutputTargetBuildItem output, BuildProducer<DeployCommandActionBuildItem> producer) throws Exception {
        if (!deployConfig.isEnabled(AZURE_FUNCTIONS)) {
            return;
        }
        this.validateParameters(config, appName.getAppName());
        this.setCurrentOperation();
        AzureMessager.setDefaultMessager((IAzureMessager)new QuarkusAzureMessager());
        Azure.az().config().setLogLevel(HttpLogDetailLevel.NONE.name());
        this.initAzureAppServiceClient(config);
        FunctionAppBase<?, ?, ?> target = this.createOrUpdateResource(config.toFunctionAppConfig(subscriptionId, appName.getAppName()));
        Path outputDirectory = output.getOutputDirectory();
        Path functionStagingDir = outputDirectory.resolve(AZURE_FUNCTIONS).resolve(appName.getAppName());
        this.deployArtifact(functionStagingDir, target);
        producer.produce((BuildItem)new DeployCommandActionBuildItem(AZURE_FUNCTIONS, true));
    }

    private void setCurrentOperation() {
        try {
            Method push = OperationThreadContext.class.getDeclaredMethod("pushOperation", Operation.class);
            push.setAccessible(true);
            OperationBase dummy = new OperationBase(){

                public Object getSource() {
                    return null;
                }

                public String getId() {
                    return "Quarkus";
                }

                public Callable<?> getBody() {
                    throw new RuntimeException("Not Implmented");
                }

                public String getType() {
                    return "Quarkus";
                }

                public AzureString getDescription() {
                    return AzureString.fromString((String)"Quarkus");
                }
            };
            OperationThreadContext ctx = OperationThreadContext.current();
            push.invoke((Object)ctx, dummy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateParameters(AzureFunctionsConfig config, String appName) throws BuildException {
        if (StringUtils.isBlank((CharSequence)appName)) {
            throw new BuildException(EMPTY_APP_NAME);
        }
        if (appName.startsWith("-") || !appName.matches(APP_NAME_PATTERN)) {
            throw new BuildException(String.format(INVALID_APP_NAME, appName));
        }
        if (StringUtils.isBlank((CharSequence)config.resourceGroup())) {
            throw new BuildException(EMPTY_RESOURCE_GROUP);
        }
        if (config.resourceGroup().endsWith(".") || !config.resourceGroup().matches(RESOURCE_GROUP_PATTERN)) {
            throw new BuildException(INVALID_RESOURCE_GROUP_NAME);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.appServicePlanName()) && !config.appServicePlanName().matches(APP_SERVICE_PLAN_NAME_PATTERN)) {
            throw new BuildException(String.format(INVALID_SERVICE_PLAN_NAME, APP_SERVICE_PLAN_NAME_PATTERN));
        }
        if (config.appServicePlanResourceGroup().isPresent() && StringUtils.isNotEmpty((CharSequence)config.appServicePlanResourceGroup().orElse(null)) && (((String)config.appServicePlanResourceGroup().orElse(null)).endsWith(".") || !((String)config.appServicePlanResourceGroup().orElse(null)).matches(RESOURCE_GROUP_PATTERN))) {
            throw new BuildException(INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.region()) && Region.fromName((String)config.region()).isExpandedValue()) {
            log.warn((Object)String.format(EXPANDABLE_REGION_WARNING, config.region()));
        }
        if (StringUtils.isNotEmpty((CharSequence)config.runtime().os()) && OperatingSystem.fromString((String)config.runtime().os()) == null) {
            throw new BuildException(INVALID_OS);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.runtime().javaVersion())) {
            log.warn((Object)String.format(EXPANDABLE_JAVA_VERSION_WARNING, config.runtime().javaVersion()));
        }
        if (config.pricingTier().isPresent() && StringUtils.isNotEmpty((CharSequence)config.pricingTier().orElse(null)) && PricingTier.fromString((String)config.pricingTier().orElse(null)).isExpandedValue()) {
            log.warn((Object)String.format(EXPANDABLE_PRICING_TIER_WARNING, config.pricingTier().orElse(null)));
        }
        if (OperatingSystem.fromString((String)config.runtime().os()) == OperatingSystem.DOCKER && StringUtils.isEmpty((CharSequence)config.runtime().image().orElse(null))) {
            throw new BuildException(EMPTY_IMAGE_NAME);
        }
    }

    protected AzureAppService initAzureAppServiceClient(AzureFunctionsConfig config) throws BuildException {
        if (appServiceClient == null) {
            Account account = this.loginAzure(config.auth());
            List subscriptions = account.getSubscriptions();
            String targetSubscriptionId = this.getTargetSubscriptionId(config.subscriptionId().orElse(null), subscriptions, account.getSelectedSubscriptions());
            AzureFunctionsDeployCommand.checkSubscription(subscriptions, targetSubscriptionId);
            ((AzureAccount)Azure.az(AzureAccount.class)).account().setSelectedSubscriptions(Collections.singletonList(targetSubscriptionId));
            appServiceClient = (AzureAppService)Azure.az(AzureAppService.class);
            this.printCurrentSubscription(appServiceClient);
            subscriptionId = targetSubscriptionId;
        }
        return appServiceClient;
    }

    protected static void checkSubscription(List<Subscription> subscriptions, String targetSubscriptionId) throws BuildException {
        if (StringUtils.isEmpty((CharSequence)targetSubscriptionId)) {
            return;
        }
        Optional<Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.getId(), (CharSequence)targetSubscriptionId)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new BuildException(String.format(SUBSCRIPTION_NOT_FOUND, targetSubscriptionId));
        }
    }

    protected Account loginAzure(AzureFunctionsConfig.AuthConfig auth) {
        if (((AzureAccount)Azure.az(AzureAccount.class)).isLoggedIn()) {
            return ((AzureAccount)Azure.az(AzureAccount.class)).account();
        }
        AuthConfiguration authConfig = auth.toAuthConfiguration();
        if (authConfig.getType() == AuthType.DEVICE_CODE) {
            authConfig.setDeviceCodeConsumer(info -> {
                String message = StringUtils.replace((String)info.getMessage(), (String)info.getUserCode(), (String)TextUtils.cyan((String)info.getUserCode()));
                System.out.println(message);
            });
        }
        AzureEnvironment configEnv = AzureEnvironmentUtils.stringToAzureEnvironment((String)authConfig.getEnvironment());
        AzureFunctionsDeployCommand.promptAzureEnvironment(configEnv);
        ((AzureCloud)Azure.az(AzureCloud.class)).set(configEnv);
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).login(authConfig, false);
        AzureEnvironment env = account.getEnvironment();
        String environmentName = AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env);
        if (env != AzureEnvironment.AZURE && env != configEnv) {
            log.info((Object)AzureString.format((String)USING_AZURE_ENVIRONMENT, (Object[])new Object[]{environmentName}));
        }
        AzureFunctionsDeployCommand.printCredentialDescription(account);
        return account;
    }

    protected static void printCredentialDescription(Account account) {
        List selectedSubscriptions;
        AuthType type = account.getType();
        String username = account.getUsername();
        if (type != null) {
            log.info((Object)AzureString.format((String)"Auth type: %s", (Object[])new Object[]{type.toString()}));
        }
        if (account.isLoggedIn() && CollectionUtils.isNotEmpty((Collection)(selectedSubscriptions = account.getSelectedSubscriptions())) && selectedSubscriptions.size() == 1) {
            log.info((Object)AzureString.format((String)"Default subscription: %s(%s)", (Object[])new Object[]{((Subscription)selectedSubscriptions.get(0)).getName(), ((Subscription)selectedSubscriptions.get(0)).getId()}));
        }
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            log.info((Object)AzureString.format((String)"Username: %s", (Object[])new Object[]{username.trim()}));
        }
    }

    private static void promptAzureEnvironment(AzureEnvironment env) {
        if (env != null && env != AzureEnvironment.AZURE) {
            log.info((Object)AzureString.format((String)"Auth environment: %s", (Object[])new Object[]{AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env)}));
        }
    }

    protected String getTargetSubscriptionId(String defaultSubscriptionId, List<Subscription> subscriptions, List<Subscription> selectedSubscriptions) throws BuildException {
        if (!StringUtils.isBlank((CharSequence)defaultSubscriptionId)) {
            return defaultSubscriptionId;
        }
        if (selectedSubscriptions.size() == 1) {
            return selectedSubscriptions.get(0).getId();
        }
        if (selectedSubscriptions.isEmpty()) {
            throw new BuildException("You account does not have a subscription to deploy to");
        }
        throw new BuildException("You must specify a subscription id to use for deployment as you have more than one");
    }

    protected void printCurrentSubscription(AzureAppService appServiceClient) {
        if (appServiceClient == null) {
            return;
        }
        List subscriptions = ((IAzureAccount)Azure.az(IAzureAccount.class)).account().getSelectedSubscriptions();
        Subscription subscription = (Subscription)subscriptions.get(0);
        if (subscription != null) {
            Log.info((Object)String.format(SUBSCRIPTION_TEMPLATE, TextUtils.cyan((String)subscription.getName()), TextUtils.cyan((String)subscription.getId())));
        }
    }

    protected FunctionAppBase<?, ?, ?> createOrUpdateResource(FunctionAppConfig config) throws Exception {
        FunctionApp app = (FunctionApp)((AzureFunctions)Azure.az(AzureFunctions.class)).functionApps(config.subscriptionId()).updateOrCreate(config.appName(), config.resourceGroup());
        boolean newFunctionApp = !app.exists();
        AppServiceConfig defaultConfig = !newFunctionApp ? AppServiceConfigUtils.fromAppService((AppServiceAppBase)app, (AppServicePlan)app.getAppServicePlan()) : this.buildDefaultConfig(config.subscriptionId(), config.resourceGroup(), config.appName());
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)config, (AppServiceConfig)defaultConfig);
        if (!newFunctionApp && !config.disableAppInsights() && StringUtils.isEmpty((CharSequence)config.appInsightsKey())) {
            config.appInsightsKey((String)app.getAppSettings().get("APPINSIGHTS_INSTRUMENTATIONKEY"));
        }
        return new CreateOrUpdateFunctionAppTask(config).doExecute();
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        return AppServiceConfig.buildDefaultFunctionConfig((String)resourceGroup, (String)appName);
    }

    private void deployArtifact(Path functionStagingDir, FunctionAppBase<?, ?, ?> target) {
        File file = functionStagingDir.toFile();
        new DeployFunctionAppTask(target, file, null).doExecute();
    }

    public static class QuarkusAzureMessager
    implements IAzureMessager,
    IAzureMessage.ValueDecorator {
        public boolean show(IAzureMessage message) {
            switch (message.getType()) {
                case ALERT: 
                case CONFIRM: 
                case WARNING: {
                    String content = message.getContent();
                    log.warn((Object)content);
                    return true;
                }
                case ERROR: {
                    log.error((Object)message.getContent(), (Throwable)message.getPayload());
                    return true;
                }
            }
            log.info((Object)message.getContent());
            return true;
        }

        public String decorateValue(@Nonnull Object p, @Nullable IAzureMessage message) {
            return TextUtils.cyan((String)p.toString());
        }
    }
}

