/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.quarkus.amazon.lambda.deployment.AmazonLambdaBuildItem;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.deployment.ProvidedAmazonLambdaHandlerBuildItem;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaRecorder;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaStaticRecorder;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.LambdaBuildTimeConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import jakarta.inject.Named;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;

public final class AmazonLambdaProcessor {
    public static final String AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS = "com/amazonaws/services/lambda/runtime/events";
    private static final DotName REQUEST_HANDLER = DotName.createSimple((String)RequestHandler.class.getName());
    private static final DotName REQUEST_STREAM_HANDLER = DotName.createSimple((String)RequestStreamHandler.class.getName());
    private static final DotName SKILL_STREAM_HANDLER = DotName.createSimple((String)"com.amazon.ask.SkillStreamHandler");
    private static final DotName NAMED = DotName.createSimple((String)Named.class.getName());
    private static final Logger log = Logger.getLogger(AmazonLambdaProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.AMAZON_LAMBDA);
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS);
    }

    @BuildStep
    List<AmazonLambdaBuildItem> discover(CombinedIndexBuildItem combinedIndexBuildItem, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) throws BuildException {
        Collection allKnownImplementors = combinedIndexBuildItem.getIndex().getAllKnownImplementors(REQUEST_HANDLER);
        allKnownImplementors.addAll(combinedIndexBuildItem.getIndex().getAllKnownImplementors(REQUEST_STREAM_HANDLER));
        allKnownImplementors.addAll(combinedIndexBuildItem.getIndex().getAllKnownSubclasses(SKILL_STREAM_HANDLER));
        if (allKnownImplementors.size() > 0 && providedLambda.isPresent()) {
            throw new BuildException("Multiple handler classes.  You have a custom handler class and the " + providedLambda.get().getProvider() + " extension.  Please remove one of them from your deployment.", Collections.emptyList());
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        ArrayList<AmazonLambdaBuildItem> ret = new ArrayList<AmazonLambdaBuildItem>();
        for (ClassInfo info : allKnownImplementors) {
            if (Modifier.isAbstract(info.flags())) continue;
            DotName name = info.name();
            String lambda = name.toString();
            builder.addBeanClass(lambda);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{lambda}).methods().build());
            String cdiName = null;
            AnnotationInstance named = info.declaredAnnotation(NAMED);
            if (named != null) {
                cdiName = named.value().asString();
            }
            ClassInfo current = info;
            boolean done = false;
            boolean streamHandler = info.superName().equals((Object)SKILL_STREAM_HANDLER);
            while (current != null && !done) {
                for (MethodInfo method : current.methods()) {
                    if (!method.name().equals("handleRequest")) continue;
                    if (method.parametersCount() == 3) {
                        streamHandler = true;
                        done = true;
                        break;
                    }
                    if (method.parametersCount() != 2 || method.parameterType(0).name().equals((Object)DotName.createSimple((String)Object.class.getName()))) continue;
                    String source = this.getClass().getSimpleName() + " > " + String.valueOf(method.declaringClass()) + "[" + String.valueOf(method) + "]";
                    reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)method.parameterType(0)).source(source).build());
                    reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)method.returnType()).source(source).build());
                    done = true;
                    break;
                }
                current = combinedIndexBuildItem.getIndex().getClassByName(current.superName());
            }
            ret.add(new AmazonLambdaBuildItem(lambda, cdiName, streamHandler));
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FunctionError.class}).methods().fields().reason(this.getClass().getName()).build());
        return ret;
    }

    @BuildStep
    void processProvidedLambda(Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) {
        if (!providedLambda.isPresent()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        Class handlerClass = providedLambda.get().getHandlerClass();
        builder.addBeanClass(handlerClass);
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{handlerClass}).methods().fields().reason(this.getClass().getName()).build());
        for (Method method : handlerClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("handleRequest") || method.getParameterCount() != 2 || (parameterTypes = method.getParameterTypes())[0].equals(Object.class)) continue;
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{parameterTypes[0].getName()}).reason(this.getClass().getName() + " > " + method.getName() + " first parameter type").methods().fields().build());
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{method.getReturnType().getName()}).reason(this.getClass().getName() + " > " + method.getName() + " return type").methods().fields().build());
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DateTime.class}).reason(this.getClass().getName()).methods().fields().build());
            break;
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void recordStaticInitHandlerClass(List<AmazonLambdaBuildItem> lambdas, LambdaObjectMapperInitializedBuildItem mapper, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, AmazonLambdaStaticRecorder recorder, RecorderContext context) {
        if (providedLambda.isPresent()) {
            boolean useStreamHandler = false;
            for (Class<?> handleInterface : providedLambda.get().getHandlerClass().getInterfaces()) {
                if (!handleInterface.getName().equals(RequestStreamHandler.class.getName())) continue;
                useStreamHandler = true;
                break;
            }
            if (useStreamHandler) {
                handlerClass = context.classProxy(providedLambda.get().getHandlerClass().getName());
                recorder.setStreamHandlerClass(handlerClass);
            } else {
                handlerClass = context.classProxy(providedLambda.get().getHandlerClass().getName());
                recorder.setHandlerClass(handlerClass);
            }
        } else if (lambdas != null && lambdas.size() == 1) {
            AmazonLambdaBuildItem item = lambdas.get(0);
            if (item.isStreamHandler()) {
                Class handlerClass = context.classProxy(item.getHandlerClass());
                recorder.setStreamHandlerClass(handlerClass);
            } else {
                Class handlerClass = context.classProxy(item.getHandlerClass());
                recorder.setHandlerClass(handlerClass);
            }
        } else if (lambdas == null || lambdas.isEmpty()) {
            String errorMessage = "Unable to find handler class, make sure your deployment includes a single " + RequestHandler.class.getName() + " or, " + RequestStreamHandler.class.getName() + " implementation";
            throw new RuntimeException(errorMessage);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordBeanContainer(BeanContainerBuildItem beanContainerBuildItem, AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.setBeanContainer(beanContainerBuildItem.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordHandlerClass(List<AmazonLambdaBuildItem> lambdas, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BeanContainerBuildItem beanContainerBuildItem, AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, RecorderContext context) {
        if (!providedLambda.isPresent() && lambdas != null && lambdas.size() > 1) {
            ArrayList<Class> unnamed = new ArrayList<Class>();
            HashMap<String, Class> named = new HashMap<String, Class>();
            ArrayList<Class> unnamedStreamHandler = new ArrayList<Class>();
            HashMap<String, Class> namedStreamHandler = new HashMap<String, Class>();
            for (AmazonLambdaBuildItem i : lambdas) {
                if (i.isStreamHandler()) {
                    if (i.getName() == null) {
                        unnamedStreamHandler.add(context.classProxy(i.getHandlerClass()));
                        continue;
                    }
                    namedStreamHandler.put(i.getName(), context.classProxy(i.getHandlerClass()));
                    continue;
                }
                if (i.getName() == null) {
                    unnamed.add(context.classProxy(i.getHandlerClass()));
                    continue;
                }
                named.put(i.getName(), context.classProxy(i.getHandlerClass()));
            }
            recorder.chooseHandlerClass(unnamed, named, unnamedStreamHandler, namedStreamHandler);
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startPoolLoop(AmazonLambdaRecorder recorder, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem, launchModeBuildItem.getLaunchMode());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startPoolLoopDevOrTest(AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem, mode);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordExpectedExceptions(LambdaBuildTimeConfig config, BuildProducer<ReflectiveClassBuildItem> registerForReflection, AmazonLambdaStaticRecorder recorder) {
        Set classes = config.expectedExceptions.map(Set::copyOf).orElseGet(Set::of);
        classes.stream().map(clazz -> ReflectiveClassBuildItem.builder((Class[])new Class[]{clazz}).constructors(false).reason(this.getClass().getName() + " expectedExceptions").build()).forEach(arg_0 -> registerForReflection.produce(arg_0));
        recorder.setExpectedExceptionClasses(classes);
    }
}

