/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.runtime.annotations.Recorder;
import org.jboss.logging.Logger;

@Recorder
public class LambdaHotReplacementRecorder {
    private static final Logger log = Logger.getLogger(LambdaHotReplacementRecorder.class);
    static volatile long nextUpdate;
    public static volatile boolean enabled;
    private static final long HOT_REPLACEMENT_INTERVAL = 2000L;
    static Object syncLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkHotReplacement() throws Exception {
        if (!enabled) {
            return false;
        }
        HotReplacementContext hotReplacementContext = DevConsoleManager.getHotReplacementContext();
        if (hotReplacementContext == null) {
            return false;
        }
        if (nextUpdate > System.currentTimeMillis() && !hotReplacementContext.isTest()) {
            if (hotReplacementContext.getDeploymentProblem() != null) {
                throw new Exception("Hot Replacement Deployment issue", hotReplacementContext.getDeploymentProblem());
            }
            return false;
        }
        Object object = syncLock;
        synchronized (object) {
            if (nextUpdate < System.currentTimeMillis() || hotReplacementContext.isTest()) {
                nextUpdate = System.currentTimeMillis() + 2000L;
                try {
                    boolean restart = hotReplacementContext.doScan(true);
                    return restart;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to perform live reload scanning", e);
                }
            }
        }
        return false;
    }

    public void enable() {
        enabled = true;
    }

    static {
        syncLock = new Object();
    }
}

