/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import io.quarkus.amazon.lambda.deployment.EventServerOverrideBuildItem;
import io.quarkus.amazon.lambda.deployment.LambdaConfig;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.runtime.LambdaHotReplacementRecorder;
import io.quarkus.amazon.lambda.runtime.MockEventServer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.Startable;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class DevServicesLambdaProcessor {
    private static final Logger log = Logger.getLogger(DevServicesLambdaProcessor.class);

    @BuildStep(onlyIfNot={IsNormal.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void enableHotReplacementChecker(LaunchModeBuildItem launchMode, LambdaHotReplacementRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency) {
        if (launchMode.getLaunchMode().isDevOrTest() && !this.legacyTestingEnabled()) {
            recorder.enable();
        }
    }

    private boolean legacyTestingEnabled() {
        try {
            Class.forName("io.quarkus.amazon.lambda.test.LambdaClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIfNot={IsNormal.class})
    public void startEventServer(LaunchModeBuildItem launchModeBuildItem, LambdaConfig config, Optional<EventServerOverrideBuildItem> override, BuildProducer<DevServicesResultBuildItem> devServicePropertiesProducer) {
        LaunchMode launchMode = launchModeBuildItem.getLaunchMode();
        if (!launchMode.isDevOrTest()) {
            return;
        }
        if (this.legacyTestingEnabled()) {
            return;
        }
        if (!config.mockEventServer().enabled()) {
            return;
        }
        MockEventServer server = override.isPresent() ? override.get().getServer().get() : new MockEventServer();
        int configuredPort = launchMode == LaunchMode.TEST ? config.mockEventServer().testPort() : config.mockEventServer().devPort();
        String portPropertySuffix = launchMode == LaunchMode.TEST ? "test-port" : "dev-port";
        String propName = "quarkus.lambda.mock-event-server." + portPropertySuffix;
        DevServicesResultBuildItem buildItem = DevServicesResultBuildItem.owned().feature(Feature.AMAZON_LAMBDA).serviceName(Feature.AMAZON_LAMBDA.getName()).serviceConfig((Object)config).startable(() -> new StartableEventServer(server, configuredPort)).configProvider(Map.of(propName, s -> String.valueOf(s.getExposedPort()), "quarkus-internal.aws-lambda.test-api", StartableEventServer::getConnectionInfo)).build();
        devServicePropertiesProducer.produce((BuildItem)buildItem);
    }

    private static class StartableEventServer
    implements Startable {
        private final MockEventServer server;
        private final int configuredPort;

        public StartableEventServer(MockEventServer server, int configuredPort) {
            this.server = server;
            this.configuredPort = configuredPort;
        }

        public void start() {
            this.server.start(this.configuredPort);
            log.debugf("Starting event server on port %d", this.configuredPort);
        }

        public int getExposedPort() {
            return this.server.getPort();
        }

        public String getConnectionInfo() {
            return "localhost:" + this.getExposedPort() + "/_lambda_";
        }

        public String getContainerId() {
            return null;
        }

        public void close() throws IOException {
            this.server.close();
        }
    }
}

