/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.DefaultApplicationModel;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gradle.tooling.DefaultProjectDescriptor;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.gradle.tooling.ProjectDescriptor;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

public abstract class QuarkusApplicationModelTask
extends DefaultTask {
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;
    public static final String QUARKUS_PROJECT_DESCRIPTOR_ARTIFACT_TYPE = "quarkus-project-descriptor";

    @Internal
    public abstract RegularFileProperty getProjectBuildFile();

    @Inject
    public abstract ProjectLayout getLayout();

    @CompileClasspath
    public abstract ConfigurableFileCollection getOriginalClasspath();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getDeploymentResolvedWorkaround();

    @Nested
    public abstract QuarkusResolvedClasspath getPlatformConfiguration();

    @Nested
    public abstract QuarkusResolvedClasspath getAppClasspath();

    @Nested
    public abstract QuarkusResolvedClasspath getDeploymentClasspath();

    @Nested
    public abstract QuarkusPlatformInfo getPlatformInfo();

    @Input
    public abstract Property<LaunchMode> getLaunchMode();

    @Input
    public abstract Property<String> getTypeModel();

    @Input
    public abstract Property<DefaultProjectDescriptor> getProjectDescriptor();

    @OutputFile
    public abstract RegularFileProperty getApplicationModel();

    public QuarkusApplicationModelTask() {
        this.getProjectBuildFile().set(this.getProject().getBuildFile());
    }

    @TaskAction
    public void execute() throws IOException {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptor().get();
        ResolvedDependencyBuilder appArtifact = this.getProjectArtifact(projectDescriptor);
        ApplicationModelBuilder modelBuilder = new ApplicationModelBuilder().setAppArtifact(appArtifact).setPlatformImports((PlatformImports)this.getPlatformInfo().resolvePlatformImports()).addReloadableWorkspaceModule(appArtifact.getKey());
        QuarkusApplicationModelTask.collectDependencies(this.getAppClasspath(), modelBuilder, projectDescriptor.getWorkspaceModule(), (ProjectDescriptor)projectDescriptor);
        QuarkusApplicationModelTask.collectExtensionDependencies(this.getDeploymentClasspath(), modelBuilder);
        DefaultApplicationModel model = modelBuilder.build();
        ToolingUtils.serializeAppModel((ApplicationModel)model, (Path)((RegularFile)this.getApplicationModel().get()).getAsFile().toPath());
    }

    private ResolvedDependencyBuilder getProjectArtifact(DefaultProjectDescriptor projectDescriptor) {
        ModuleVersionIdentifier moduleVersion = ((ResolvedComponentResult)this.getAppClasspath().getRoot().get()).getModuleVersion();
        ResolvedDependencyBuilder appArtifact = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(moduleVersion.getGroup())).setArtifactId(moduleVersion.getName())).setVersion(moduleVersion.getVersion());
        WorkspaceModule.Mutable module = projectDescriptor.getWorkspaceModule();
        module.setModuleId(WorkspaceModuleId.of((String)appArtifact.getGroupId(), (String)appArtifact.getArtifactId(), (String)appArtifact.getVersion()));
        ArtifactSources mainSources = module.getMainSources();
        if (mainSources != null) {
            PathList.Builder paths = PathList.builder();
            QuarkusApplicationModelTask.collectDestinationDirs(module.getMainSources().getSourceDirs(), paths);
            QuarkusApplicationModelTask.collectDestinationDirs(module.getMainSources().getResourceDirs(), paths);
            appArtifact.setResolvedPaths((PathCollection)paths.build());
        } else {
            appArtifact.setResolvedPaths((PathCollection)PathList.empty());
        }
        return appArtifact.setWorkspaceModule((WorkspaceModule)module);
    }

    private static void collectDestinationDirs(Collection<SourceDir> sources, PathList.Builder paths) {
        for (SourceDir src : sources) {
            Path path = src.getOutputDir();
            if (paths.contains(path) || !Files.exists(path, new LinkOption[0])) continue;
            paths.add(path);
        }
    }

    private static void collectDependencies(QuarkusResolvedClasspath classpath, ApplicationModelBuilder modelBuilder, WorkspaceModule.Mutable wsModule, ProjectDescriptor projectDescriptor) {
        Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifacts = classpath.resolvedArtifactsByComponentIdentifier();
        HashSet alreadyCollectedFiles = new HashSet(artifacts.size());
        HashSet processedModules = new HashSet();
        ((ResolvedComponentResult)classpath.getRoot().get()).getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                ResolvedDependencyResult resolved = (ResolvedDependencyResult)d;
                int flags = 7;
                QuarkusApplicationModelTask.collectDependencies(resolved, modelBuilder, artifacts, wsModule, alreadyCollectedFiles, processedModules, (byte)7, projectDescriptor);
            }
        });
        HashSet<File> fileDependencies = new HashSet<File>(classpath.getAllResolvedFiles().getFiles());
        fileDependencies.removeAll(alreadyCollectedFiles);
        QuarkusApplicationModelTask.fileDependenciesExtractor(modelBuilder, fileDependencies);
    }

    private static void fileDependenciesExtractor(ApplicationModelBuilder modelBuilder, Set<File> fileDependencies) {
        for (File f : fileDependencies) {
            int dot;
            if (!f.exists()) continue;
            String parentPath = f.getParent();
            String group = HashUtil.sha1((String)(parentPath == null ? f.getName() : parentPath));
            String name = f.getName();
            String type = "jar";
            if (!f.isDirectory() && (dot = f.getName().lastIndexOf(46)) > 0) {
                name = f.getName().substring(0, dot);
                type = f.getName().substring(dot + 1);
            }
            String version = String.valueOf(f.lastModified());
            ResolvedDependencyBuilder artifactBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(group)).setArtifactId(name)).setType(type)).setVersion(version)).setResolvedPath(f.toPath()).setDirect(true)).setRuntimeCp()).setDeploymentCp();
            Utils.processQuarkusDependency(artifactBuilder, modelBuilder);
            modelBuilder.addDependency(artifactBuilder);
        }
    }

    private static void collectDependencies(ResolvedDependencyResult resolvedDependency, ApplicationModelBuilder modelBuilder, Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> resolvedArtifacts, WorkspaceModule.Mutable parentModule, Set<File> collectedArtifactFiles, Set<ModuleVersionIdentifier> processedModules, byte flags, ProjectDescriptor projectDescriptor) {
        ModuleVersionIdentifier moduleId = QuarkusApplicationModelTask.getModuleVersion(resolvedDependency);
        if (!processedModules.add(moduleId)) {
            return;
        }
        WorkspaceModule.Mutable projectModule = projectDescriptor.getWorkspaceModuleOrNull(WorkspaceModuleId.of((String)moduleId.getGroup(), (String)moduleId.getName(), (String)moduleId.getVersion()));
        List<QuarkusResolvedArtifact> artifacts = QuarkusApplicationModelTask.getResolvedModuleArtifacts(resolvedArtifacts, resolvedDependency.getSelected().getId());
        if (artifacts.isEmpty()) {
            byte finalFlags = flags;
            resolvedDependency.getSelected().getDependencies().forEach(dependencyResult -> {
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedDependencyResult result = (ResolvedDependencyResult)dependencyResult;
                    QuarkusApplicationModelTask.collectDependencies(result, modelBuilder, resolvedArtifacts, projectModule, collectedArtifactFiles, processedModules, finalFlags, projectDescriptor);
                }
            });
            return;
        }
        byte newFlags = flags;
        for (QuarkusResolvedArtifact artifact : artifacts) {
            collectedArtifactFiles.add(artifact.file);
            String classifier = QuarkusApplicationModelTask.resolveClassifier(moduleId, artifact.file);
            ArtifactKey artifactKey = ArtifactKey.of((String)moduleId.getGroup(), (String)moduleId.getName(), (String)classifier, (String)artifact.type);
            if (!QuarkusApplicationModelTask.isDependency(artifact) || modelBuilder.getDependency(artifactKey) != null || modelBuilder.getApplicationArtifact().getKey().equals((Object)artifactKey)) continue;
            GACTV depCoords = new GACTV(artifactKey, moduleId.getVersion());
            ResolvedDependencyBuilder depBuilder = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords((ArtifactCoords)depCoords)).setRuntimeCp()).setDeploymentCp()).setResolvedPath(artifact.file.toPath()).setWorkspaceModule((WorkspaceModule)projectModule);
            if (GradleApplicationModelBuilder.isFlagOn((byte)flags, (byte)2)) {
                depBuilder.setDirect(true);
                newFlags = GradleApplicationModelBuilder.clearFlag((byte)newFlags, (byte)2);
            }
            if (parentModule != null) {
                parentModule.addDependency((Dependency)new ArtifactDependency((ArtifactCoords)depCoords, new int[0]));
            }
            if (Utils.processQuarkusDependency(depBuilder, modelBuilder)) {
                if (GradleApplicationModelBuilder.isFlagOn((byte)flags, (byte)1)) {
                    depBuilder.setFlags(128);
                    newFlags = GradleApplicationModelBuilder.clearFlag((byte)newFlags, (byte)1);
                }
                newFlags = GradleApplicationModelBuilder.clearFlag((byte)newFlags, (byte)4);
            }
            if (GradleApplicationModelBuilder.isFlagOn((byte)flags, (byte)4)) {
                if (projectModule != null) {
                    depBuilder.setFlags(64);
                    modelBuilder.addReloadableWorkspaceModule(artifactKey);
                } else {
                    newFlags = GradleApplicationModelBuilder.clearFlag((byte)newFlags, (byte)4);
                }
            }
            modelBuilder.addDependency(depBuilder);
        }
        flags = newFlags;
        for (DependencyResult dependency : resolvedDependency.getSelected().getDependencies()) {
            if (!(dependency instanceof ResolvedDependencyResult)) continue;
            ResolvedDependencyResult result = (ResolvedDependencyResult)dependency;
            QuarkusApplicationModelTask.collectDependencies(result, modelBuilder, resolvedArtifacts, projectModule, collectedArtifactFiles, processedModules, flags, projectDescriptor);
        }
    }

    private static ModuleVersionIdentifier getModuleVersion(ResolvedDependencyResult resolvedDependency) {
        return Objects.requireNonNull(resolvedDependency.getSelected().getModuleVersion());
    }

    private static boolean isDependency(QuarkusResolvedArtifact a) {
        return a.file.getName().endsWith("jar") || a.file.getName().endsWith(".exe") || a.file.isDirectory();
    }

    private static void collectExtensionDependencies(QuarkusResolvedClasspath classpath, ApplicationModelBuilder modelBuilder) {
        Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifacts = classpath.resolvedArtifactsByComponentIdentifier();
        HashSet alreadyVisited = new HashSet();
        ((ResolvedComponentResult)classpath.getRoot().get()).getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                ResolvedDependencyResult result = (ResolvedDependencyResult)d;
                QuarkusApplicationModelTask.collectExtensionDependencies(result, modelBuilder, artifacts, alreadyVisited);
            }
        });
    }

    private static void collectExtensionDependencies(ResolvedDependencyResult resolvedDependency, ApplicationModelBuilder modelBuilder, Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> resolvedArtifacts, Set<ArtifactKey> alreadyVisited) {
        List<QuarkusResolvedArtifact> artifacts = QuarkusApplicationModelTask.getResolvedModuleArtifacts(resolvedArtifacts, resolvedDependency.getSelected().getId());
        if (artifacts.isEmpty()) {
            return;
        }
        ModuleVersionIdentifier moduleVersionIdentifier = QuarkusApplicationModelTask.getModuleVersion(resolvedDependency);
        for (QuarkusResolvedArtifact artifact : artifacts) {
            String classifier = QuarkusApplicationModelTask.resolveClassifier(moduleVersionIdentifier, artifact.file);
            GACT artifactKey = new GACT(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), classifier, artifact.type);
            if (!alreadyVisited.add((ArtifactKey)artifactKey)) {
                return;
            }
            ResolvedDependencyBuilder dep = modelBuilder.getDependency((ArtifactKey)artifactKey);
            if (dep == null) {
                GACTV artifactCoords = new GACTV((ArtifactKey)artifactKey, moduleVersionIdentifier.getVersion());
                dep = QuarkusApplicationModelTask.toDependency((ArtifactCoords)artifactCoords, artifact.file, new int[0]);
                modelBuilder.addDependency(dep);
            }
            dep.setDeploymentCp();
            dep.clearFlag(64);
        }
        resolvedDependency.getSelected().getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                ResolvedDependencyResult result = (ResolvedDependencyResult)d;
                QuarkusApplicationModelTask.collectExtensionDependencies(result, modelBuilder, resolvedArtifacts, alreadyVisited);
            }
        });
    }

    private static List<QuarkusResolvedArtifact> getResolvedModuleArtifacts(Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifacts, ComponentIdentifier moduleId) {
        return artifacts.getOrDefault(moduleId, List.of());
    }

    private static String resolveClassifier(ModuleVersionIdentifier moduleVersionIdentifier, File file) {
        String artifactIdVersion;
        String string = artifactIdVersion = moduleVersionIdentifier.getVersion().isEmpty() || "unspecified".equals(moduleVersionIdentifier.getVersion()) ? moduleVersionIdentifier.getName() : moduleVersionIdentifier.getName() + "-" + moduleVersionIdentifier.getVersion();
        if ((file.getName().endsWith(".jar") || file.getName().endsWith(".pom") || file.getName().endsWith(".exe")) && file.getName().startsWith(artifactIdVersion + "-")) {
            return file.getName().substring(artifactIdVersion.length() + 1, file.getName().length() - 4);
        }
        return "";
    }

    static ResolvedDependencyBuilder toDependency(ArtifactCoords artifactCoords, File file, int ... flags) {
        int allFlags = 0;
        for (int f : flags) {
            allFlags |= f;
        }
        return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(artifactCoords)).setResolvedPaths((PathCollection)PathList.of((Path[])new Path[]{file.toPath()})).setFlags(allFlags);
    }

    public static abstract class QuarkusPlatformInfo {
        @Internal
        public abstract Property<ArtifactCollection> getResolvedArtifactCollection();

        private PlatformImportsImpl resolvePlatformImports() {
            PlatformImportsImpl result = new PlatformImportsImpl();
            for (ResolvedArtifactResult artifact : ((ArtifactCollection)this.getResolvedArtifactCollection().get()).getArtifacts()) {
                ModuleComponentIdentifier compId = ((ModuleComponentArtifactIdentifier)artifact.getId()).getComponentIdentifier();
                String artifactId = artifact.getFile().getName();
                if (artifactId.endsWith(".json")) {
                    result.addPlatformDescriptor(compId.getGroup(), compId.getModuleIdentifier().getName(), compId.getVersion(), "json", compId.getVersion());
                    continue;
                }
                if (!artifactId.endsWith(".properties")) continue;
                try {
                    result.addPlatformProperties(compId.getGroup(), compId.getModuleIdentifier().getName(), "", "json", compId.getVersion(), artifact.getFile().toPath());
                }
                catch (AppModelResolverException e) {
                    throw new RuntimeException("Failed to add platform properties " + String.valueOf(artifact), e);
                }
            }
            return result;
        }

        public void configureFrom(Configuration configuration) {
            this.getResolvedArtifactCollection().set((Object)configuration.getIncoming().getArtifacts());
        }
    }

    public static abstract class QuarkusResolvedClasspath {
        @Internal
        public abstract Property<ResolvedComponentResult> getRoot();

        @Internal
        public abstract Property<ArtifactCollection> getResolvedArtifactCollection();

        private FileCollection getAllResolvedFiles() {
            return ((ArtifactCollection)this.getResolvedArtifactCollection().get()).getArtifactFiles();
        }

        private Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> resolvedArtifactsByComponentIdentifier() {
            return this.getQuarkusResolvedArtifacts().stream().collect(Collectors.groupingBy(artifact -> artifact.getId().getComponentIdentifier()));
        }

        private List<QuarkusResolvedArtifact> getQuarkusResolvedArtifacts() {
            return ((ArtifactCollection)this.getResolvedArtifactCollection().get()).getArtifacts().stream().map(this::toResolvedArtifact).collect(Collectors.toList());
        }

        private QuarkusResolvedArtifact toResolvedArtifact(ResolvedArtifactResult result) {
            String type = (String)result.getVariant().getAttributes().getAttribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
            return new QuarkusResolvedArtifact(result.getId(), result.getFile(), type);
        }

        public void configureFrom(Configuration configuration) {
            ResolvableDependencies resolvableDependencies = configuration.getIncoming();
            this.getRoot().set(resolvableDependencies.getResolutionResult().getRootComponent());
            this.getResolvedArtifactCollection().set((Object)resolvableDependencies.getArtifacts());
        }
    }

    public static class Utils {
        public static boolean processQuarkusDependency(ResolvedDependencyBuilder artifactBuilder, ApplicationModelBuilder modelBuilder) {
            Path artifactPath;
            Iterator iterator = artifactBuilder.getResolvedPaths().iterator();
            if (iterator.hasNext() && Files.exists(artifactPath = (Path)iterator.next(), new LinkOption[0]) && artifactBuilder.getType().equals("jar")) {
                boolean bl;
                block10: {
                    if (Files.isDirectory(artifactPath, new LinkOption[0])) {
                        return Utils.processQuarkusDir(artifactBuilder, artifactPath.resolve("META-INF"), modelBuilder);
                    }
                    FileSystem artifactFs = ZipUtils.newFileSystem((Path)artifactPath);
                    try {
                        bl = Utils.processQuarkusDir(artifactBuilder, artifactFs.getPath("META-INF", new String[0]), modelBuilder);
                        if (artifactFs == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (artifactFs != null) {
                                try {
                                    artifactFs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to process " + String.valueOf(artifactPath), e);
                        }
                    }
                    artifactFs.close();
                }
                return bl;
            }
            return false;
        }

        private static boolean processQuarkusDir(ResolvedDependencyBuilder artifactBuilder, Path quarkusDir, ApplicationModelBuilder modelBuilder) {
            if (!Files.exists(quarkusDir, new LinkOption[0])) {
                return false;
            }
            Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
            if (!Files.exists(quarkusDescr, new LinkOption[0])) {
                return false;
            }
            Properties extProps = Utils.readDescriptor(quarkusDescr);
            if (extProps == null) {
                return false;
            }
            artifactBuilder.setRuntimeExtensionArtifact();
            modelBuilder.handleExtensionProperties(extProps, artifactBuilder.getKey());
            String providesCapabilities = extProps.getProperty("provides-capabilities");
            if (providesCapabilities != null) {
                modelBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.of((String)artifactBuilder.toGACTVString(), (String)providesCapabilities, null));
            }
            return true;
        }

        private static Properties readDescriptor(Path path) {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            Properties rtProps = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(path);){
                rtProps.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load extension description " + String.valueOf(path), e);
            }
            return rtProps;
        }
    }

    public static class QuarkusResolvedArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ComponentArtifactIdentifier id;
        private final String type;
        private final File file;

        public QuarkusResolvedArtifact(ComponentArtifactIdentifier id, File file, String type) {
            this.id = id;
            this.type = type;
            this.file = file;
        }

        public ComponentArtifactIdentifier getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public File getFile() {
            return this.file;
        }
    }
}

