/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.workspace.descriptors;

import io.quarkus.gradle.workspace.descriptors.ProjectDescriptor;
import io.quarkus.gradle.workspace.descriptors.QuarkusTaskDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DefaultProjectDescriptor
implements Serializable,
ProjectDescriptor {
    private static final long serialVersionUID = 1L;
    private final File projectDir;
    private final File buildDir;
    private final File buildFile;
    private final Map<String, QuarkusTaskDescriptor> tasks;
    private final Map<String, Set<String>> sourceSetTasks;
    private final Map<String, Set<String>> sourceSetTasksRaw;

    public DefaultProjectDescriptor(File projectDir, File buildDir, File buildFile, Map<String, QuarkusTaskDescriptor> tasks, Map<String, Set<String>> sourceSetTasks, Map<String, Set<String>> sourceSetTasksRaw) {
        this.projectDir = projectDir;
        this.buildDir = buildDir;
        this.buildFile = buildFile;
        this.tasks = tasks;
        this.sourceSetTasks = sourceSetTasks;
        this.sourceSetTasksRaw = sourceSetTasksRaw;
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.buildDir;
    }

    @Override
    public File getBuildFile() {
        return this.buildFile;
    }

    public Map<String, Set<String>> getSourceSetTasks() {
        return this.sourceSetTasks;
    }

    public Map<String, Set<String>> getSourceSetTasksRaw() {
        return this.sourceSetTasksRaw;
    }

    public Map<String, QuarkusTaskDescriptor> getTasks() {
        return this.tasks;
    }

    @Override
    public Set<String> getTasksForSourceSet(String sourceSetName) {
        return this.sourceSetTasks.getOrDefault(sourceSetName, Collections.emptySet());
    }

    @Override
    public String getTaskSource(String task) {
        return this.tasks.get(task).getSourceDir().getAbsolutePath();
    }

    @Override
    public String getTaskDestinationDir(String task) {
        return this.tasks.get(task).getDestinationDir().getAbsolutePath();
    }

    @Override
    public ProjectDescriptor.TaskType getTaskType(String task) {
        return this.tasks.get(task).getTaskType();
    }

    public DefaultProjectDescriptor withSourceSetView(Set<String> acceptedSourceSets) {
        Map filteredSourceSets = this.sourceSetTasks.entrySet().stream().filter(e -> acceptedSourceSets.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
        Map filteredTasks = this.tasks.entrySet().stream().filter(e -> filteredSourceSets.values().stream().anyMatch(tasks -> tasks.contains(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
        return new DefaultProjectDescriptor(this.projectDir, this.buildDir, this.buildFile, filteredTasks, filteredSourceSets, this.sourceSetTasksRaw);
    }

    public String toString() {
        return "DefaultProjectDescriptor{\nprojectDir=" + String.valueOf(this.projectDir) + ",\nbuildDir=" + String.valueOf(this.buildDir) + ",\nbuildFile=" + String.valueOf(this.buildFile) + ",\ntasks=" + String.valueOf(this.tasks) + ",\nsourceSetTasks=" + String.valueOf(this.sourceSetTasks) + ",\nsourceSetTasksRaw=" + String.valueOf(this.sourceSetTasksRaw) + "\n}";
    }
}

