/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.CodeGenerator;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;

public class QuarkusGenerateCode
extends QuarkusTask {
    public static final String QUARKUS_GENERATED_SOURCES = "quarkus-generated-sources";
    public static final String QUARKUS_TEST_GENERATED_SOURCES = "quarkus-test-generated-sources";
    public static final String[] CODE_GENERATION_PROVIDER = new String[]{"grpc", "avdl", "avpr", "avsc"};
    public static final String[] CODE_GENERATION_INPUT = new String[]{"proto", "avro"};
    public static final String INIT_AND_RUN = "initAndRun";
    private Set<Path> sourcesDirectories;
    private Configuration compileClasspath;
    private Consumer<Path> sourceRegistrar = p -> {};
    private boolean test = false;
    private boolean devMode = false;

    public QuarkusGenerateCode() {
        super("Performs Quarkus pre-build preparations, such as sources generation");
    }

    @CompileClasspath
    public Configuration getClasspath() {
        return this.compileClasspath;
    }

    public void setCompileClasspath(Configuration compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    @InputFiles
    public Set<File> getInputDirectory() {
        HashSet<File> inputDirectories = new HashSet<File>();
        String inputSourceSetName = this.test ? "test" : "main";
        Path src = this.getProject().getProjectDir().toPath().resolve("src").resolve(inputSourceSetName);
        for (String input : CODE_GENERATION_INPUT) {
            Path providerSrcDir = src.resolve(input);
            if (!Files.exists(providerSrcDir, new LinkOption[0])) continue;
            inputDirectories.add(providerSrcDir.toFile());
        }
        return inputDirectories;
    }

    @OutputDirectory
    public File getGeneratedOutputDirectory() {
        String generatedSourceSetName = this.test ? QUARKUS_TEST_GENERATED_SOURCES : QUARKUS_GENERATED_SOURCES;
        return ((Directory)QuarkusGradleUtils.getSourceSet(this.getProject(), generatedSourceSetName).getJava().getClassesDirectory().get()).getAsFile();
    }

    @TaskAction
    public void prepareQuarkus() {
        LaunchMode launchMode = this.test ? LaunchMode.TEST : (this.devMode ? LaunchMode.DEVELOPMENT : LaunchMode.NORMAL);
        ApplicationModel appModel = this.extension().getApplicationModel(launchMode);
        Properties realProperties = this.getBuildSystemProperties(appModel.getAppArtifact());
        Path buildDir = this.getProject().getBuildDir().toPath();
        try (CuratedApplication appCreationContext = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setExistingModel(appModel).setTargetDirectory(buildDir).setBaseName(this.extension().finalName()).setBuildSystemProperties(realProperties).setAppArtifact(appModel.getAppArtifact()).setLocalProjectDiscovery(Boolean.valueOf(false)).setIsolateDeployment(true).build().bootstrap();){
            Method initAndRun;
            SourceSetContainer sourceSets = (SourceSetContainer)this.getProject().getExtensions().getByType(SourceSetContainer.class);
            String generateSourcesDir = this.test ? QUARKUS_TEST_GENERATED_SOURCES : QUARKUS_GENERATED_SOURCES;
            SourceSet generatedSources = (SourceSet)sourceSets.getByName(generateSourcesDir);
            ArrayList paths = new ArrayList();
            generatedSources.getOutput().filter(f -> f.getName().equals(generateSourcesDir)).forEach(f -> paths.add(f.toPath()));
            if (paths.isEmpty()) {
                throw new GradleException("Failed to create quarkus-generated-sources");
            }
            this.getLogger().debug("Will trigger preparing sources for source directory: {} buildDir: {}", this.sourcesDirectories, (Object)this.getProject().getBuildDir().getAbsolutePath());
            QuarkusClassLoader deploymentClassLoader = appCreationContext.createDeploymentClassLoader();
            Class codeGenerator = deploymentClassLoader.loadClass(CodeGenerator.class.getName());
            try {
                initAndRun = codeGenerator.getMethod(INIT_AND_RUN, QuarkusClassLoader.class, PathCollection.class, Path.class, Path.class, Consumer.class, ApplicationModel.class, Properties.class, String.class, Boolean.TYPE);
            }
            catch (Exception e) {
                throw new GradleException("Quarkus code generation phase has failed", (Throwable)e);
            }
            initAndRun.invoke(null, deploymentClassLoader, PathList.from(this.sourcesDirectories), paths.get(0), buildDir, this.sourceRegistrar, appCreationContext.getApplicationModel(), realProperties, launchMode.name(), this.test);
        }
        catch (BootstrapException | ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new GradleException("Failed to generate sources in the QuarkusPrepare task", e);
        }
    }

    public void setSourcesDirectories(Set<Path> sourcesDirectories) {
        this.sourcesDirectories = sourcesDirectories;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }
}

