/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.tasks.ImageTask;
import io.quarkus.gradle.tasks.QuarkusBuildConfiguration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class ImageBuild
extends ImageTask {
    Builder builder = Builder.docker;

    @Option(option="builder", description="The container image extension to use for building the image (e.g. docker, jib, buildpack, openshift).")
    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    @Inject
    public ImageBuild(QuarkusBuildConfiguration buildConfiguration) {
        super(buildConfiguration, "Perform an image build");
    }

    @Override
    public Map<String, String> forcedProperties() {
        return Map.of("quarkus.container-image.build", "true", "quarkus.container-image.builder", this.builder.name());
    }

    @TaskAction
    public void checkRequiredExtensions() {
        String requiredExtension = "quarkus-container-image-" + this.builder.name();
        String requiredDependency = requiredExtension + "-deployment";
        List projectDependencies = this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).collect(Collectors.toList());
        if (!projectDependencies.contains(requiredDependency)) {
            this.getProject().getLogger().warn("Task: {} requires extensions: {}", (Object)this.getName(), (Object)requiredDependency);
            this.getProject().getLogger().warn("To add the extensions to the project you can run the following command:");
            this.getProject().getLogger().warn("\tgradle addExtension --extensions={}", (Object)requiredExtension);
        }
    }

    public static enum Builder {
        docker,
        jib,
        buildpack,
        openshift;

    }
}

