/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ScopeInfo;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class Interceptors {
    static final Logger LOGGER = Logger.getLogger(Interceptors.class);

    private Interceptors() {
    }

    static InterceptorInfo createInterceptor(ClassInfo interceptorClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        Integer priority = null;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)interceptorClass)) {
            ScopeInfo scope;
            if (annotation.name().equals((Object)DotNames.PRIORITY)) {
                priority = annotation.value().asInt();
            }
            if ((scope = beanDeployment.getScope(annotation.name())) == null || BuiltinScope.DEPENDENT.is(scope)) continue;
            throw new DefinitionException("Interceptor declares scope other than @Dependent: " + String.valueOf(interceptorClass));
        }
        HashSet<AnnotationInstance> bindings = new HashSet<AnnotationInstance>();
        Interceptors.addBindings(beanDeployment, interceptorClass, bindings, false);
        if (bindings.isEmpty()) {
            throw new DefinitionException("Interceptor has no bindings: " + String.valueOf(interceptorClass));
        }
        if (priority == null) {
            if (beanDeployment.strictCompatibility) {
                return null;
            }
            LOGGER.info((Object)("The interceptor " + String.valueOf(interceptorClass) + " does not declare any @Priority. It will be assigned a default priority value of 0."));
            priority = 0;
        }
        Interceptors.checkClassLevelInterceptorBindings(bindings, interceptorClass, beanDeployment);
        Interceptors.checkInterceptorFieldsAndMethods(interceptorClass, beanDeployment);
        return new InterceptorInfo((AnnotationTarget)interceptorClass, beanDeployment, bindings.size() == 1 ? Set.of((AnnotationInstance)bindings.iterator().next()) : Collections.unmodifiableSet(bindings), Injection.forBean((AnnotationTarget)interceptorClass, null, beanDeployment, transformer, Injection.BeanType.INTERCEPTOR), priority);
    }

    private static void addBindings(BeanDeployment beanDeployment, ClassInfo classInfo, Collection<AnnotationInstance> bindings, boolean onlyInherited) {
        ClassInfo superClass;
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)classInfo)) {
            ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), annotation.name());
            if (onlyInherited && !beanDeployment.hasAnnotation((AnnotationTarget)annotationClass, DotNames.INHERITED)) continue;
            bindings.addAll(beanDeployment.extractInterceptorBindings(annotation));
        }
        if (classInfo.superName() != null && !classInfo.superName().equals((Object)DotNames.OBJECT) && (superClass = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            Interceptors.addBindings(beanDeployment, superClass, bindings, true);
        }
    }

    static void checkClassLevelInterceptorBindings(Collection<AnnotationInstance> bindings, ClassInfo targetClass, BeanDeployment beanDeployment) {
        IndexView index = beanDeployment.getBeanArchiveIndex();
        HashMap<DotName, List> seenBindings = new HashMap<DotName, List>();
        for (AnnotationInstance binding : bindings) {
            DotName name = binding.name();
            if (beanDeployment.hasAnnotation((AnnotationTarget)index.getClassByName(name), DotNames.REPEATABLE)) continue;
            List seenValues = (List)seenBindings.get(name);
            if (seenValues != null) {
                ClassInfo declaration = beanDeployment.getInterceptorBinding(name);
                Set<String> nonBindingMembers = beanDeployment.getInterceptorNonbindingMembers(name);
                for (AnnotationValue value : seenValues) {
                    if (declaration.method(value.name(), new Type[0]).hasDeclaredAnnotation(DotNames.NONBINDING) || nonBindingMembers.contains(value.name()) || value.equals((Object)binding.valueWithDefault(index, value.name()))) continue;
                    throw new DefinitionException("Multiple instances of non-repeatable interceptor binding annotation " + String.valueOf(name) + " with different member values on class " + String.valueOf(targetClass));
                }
                continue;
            }
            seenBindings.put(name, binding.valuesWithDefaults(index));
        }
    }

    private static void checkInterceptorFieldsAndMethods(ClassInfo interceptorClass, BeanDeployment beanDeployment) {
        ClassInfo aClass = interceptorClass;
        while (aClass != null) {
            for (MethodInfo method : aClass.methods()) {
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) {
                    throw new DefinitionException("Interceptor declares a producer method: " + String.valueOf(interceptorClass));
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    throw new DefinitionException("Interceptor declares a disposer method: " + String.valueOf(interceptorClass));
                }
                if (beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES)) {
                    throw new DefinitionException("Interceptor declares an observer method: " + String.valueOf(interceptorClass));
                }
                if (!beanDeployment.hasAnnotation((AnnotationTarget)method, DotNames.OBSERVES_ASYNC)) continue;
                throw new DefinitionException("Interceptor declares an async observer method: " + String.valueOf(interceptorClass));
            }
            for (FieldInfo field : aClass.fields()) {
                if (!beanDeployment.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                throw new DefinitionException("Interceptor declares a producer field: " + String.valueOf(interceptorClass));
            }
            DotName superClass = aClass.superName();
            aClass = superClass != null && !superClass.equals((Object)DotNames.OBJECT) ? IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superClass) : null;
        }
    }
}

