/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.DoubleAdder;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Gauge
extends SimpleCollector<Child, Gauge> {
    Gauge(Builder b) {
        super(b);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void inc() {
        this.inc(1.0);
    }

    public void inc(double amt) {
        ((Child)this.noLabelsChild).inc(amt);
    }

    public void dec() {
        this.dec(1.0);
    }

    public void dec(double amt) {
        ((Child)this.noLabelsChild).dec(amt);
    }

    public void set(double val) {
        ((Child)this.noLabelsChild).set(val);
    }

    public void setToCurrentTime() {
        ((Child)this.noLabelsChild).setToCurrentTime();
    }

    public Timer startTimer() {
        return ((Child)this.noLabelsChild).startTimer();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, (List)c.getKey(), ((Child)c.getValue()).get()));
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, Collector.Type.GAUGE, this.help, samples);
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.add(mfs);
        return mfsList;
    }

    static class TimeProvider {
        TimeProvider() {
        }

        long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        long nanoTime() {
            return System.nanoTime();
        }
    }

    public static class Child {
        private DoubleAdder value = new DoubleAdder();
        static TimeProvider timeProvider = new TimeProvider();

        public void inc() {
            this.inc(1.0);
        }

        public void inc(double amt) {
            this.value.add(amt);
        }

        public void dec() {
            this.dec(1.0);
        }

        public void dec(double amt) {
            this.value.add(-amt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(double val) {
            Child child = this;
            synchronized (child) {
                this.value.reset();
                this.value.add(val);
            }
        }

        public void setToCurrentTime() {
            this.set((double)timeProvider.currentTimeMillis() / 1000.0);
        }

        public Timer startTimer() {
            return new Timer(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double get() {
            Child child = this;
            synchronized (child) {
                return this.value.sum();
            }
        }
    }

    public static class Timer {
        Child child;
        long start;

        private Timer(Child child) {
            this.child = child;
            this.start = Child.timeProvider.nanoTime();
        }

        public void setDuration() {
            this.child.set((double)(Child.timeProvider.nanoTime() - this.start) / 1.0E9);
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Gauge> {
        @Override
        public Gauge create() {
            return new Gauge(this);
        }
    }
}

