/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public abstract class Collector {
    public abstract MetricFamilySamples[] collect();

    public Collector register() {
        return this.register(CollectorRegistry.defaultRegistry);
    }

    public Collector register(CollectorRegistry registry) {
        registry.register(this);
        return this;
    }

    public static class MetricFamilySamples {
        public final String name;
        public final Type type;
        public final String help;
        public final Vector<Sample> samples;

        public MetricFamilySamples(String name, Type type, String help, Vector<Sample> samples) {
            this.name = name;
            this.type = type;
            this.help = help;
            this.samples = samples;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MetricFamilySamples)) {
                return false;
            }
            MetricFamilySamples other = (MetricFamilySamples)obj;
            return other.name.equals(this.name) && other.type.equals((Object)this.type) && other.help.equals(this.help) && other.samples.equals(this.samples);
        }

        public int hashCode() {
            int hash = 1;
            hash = 37 * hash + this.name.hashCode();
            hash = 37 * hash + this.type.hashCode();
            hash = 37 * hash + this.help.hashCode();
            hash = 37 * hash + this.samples.hashCode();
            return hash;
        }

        public String toString() {
            return "Name: " + this.name + " Type: " + (Object)((Object)this.type) + " Help: " + this.help + " Samples: " + this.samples;
        }

        public static class Sample {
            public final String name;
            public final String[] labelNames;
            public final List<String> labelValues;
            public final double value;

            public Sample(String name, String[] labelNames, List<String> labelValues, double value) {
                this.name = name;
                this.labelNames = labelNames;
                this.labelValues = labelValues;
                this.value = value;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Sample)) {
                    return false;
                }
                Sample other = (Sample)obj;
                return other.name.equals(this.name) && Arrays.equals(other.labelNames, this.labelNames) && other.labelValues.equals(this.labelValues) && other.value == this.value;
            }

            public int hashCode() {
                int hash = 1;
                hash = 37 * hash + this.name.hashCode();
                hash = 37 * hash + this.labelNames.hashCode();
                hash = 37 * hash + this.labelValues.hashCode();
                long d = Double.doubleToLongBits(this.value);
                hash = 37 * hash + (int)(d ^ d >>> 32);
                return hash;
            }

            public String toString() {
                return "Name: " + this.name + " LabelNames: " + Arrays.asList(this.labelNames) + " labelValues: " + this.labelValues + " Value: " + this.value;
            }
        }
    }

    public static enum Type {
        COUNTER,
        GAUGE,
        SUMMARY;

    }
}

