/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.inference.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.inference.client.JSON;

public class RerankRequest {
    public static final String SERIALIZED_NAME_MODEL = "model";
    @SerializedName(value="model")
    private String model;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_TOP_N = "top_n";
    @SerializedName(value="top_n")
    private Integer topN;
    public static final String SERIALIZED_NAME_RETURN_DOCUMENTS = "return_documents";
    @SerializedName(value="return_documents")
    private Boolean returnDocuments = true;
    public static final String SERIALIZED_NAME_RANK_FIELDS = "rank_fields";
    @SerializedName(value="rank_fields")
    private List<String> rankFields = new ArrayList<String>(Arrays.asList("text"));
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<Map<String, Object>> documents = new ArrayList<Map<String, Object>>();
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RerankRequest model(String model) {
        this.model = model;
        return this;
    }

    @Nonnull
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public RerankRequest query(String query) {
        this.query = query;
        return this;
    }

    @Nonnull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public RerankRequest topN(Integer topN) {
        this.topN = topN;
        return this;
    }

    @Nullable
    public Integer getTopN() {
        return this.topN;
    }

    public void setTopN(Integer topN) {
        this.topN = topN;
    }

    public RerankRequest returnDocuments(Boolean returnDocuments) {
        this.returnDocuments = returnDocuments;
        return this;
    }

    @Nullable
    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public void setReturnDocuments(Boolean returnDocuments) {
        this.returnDocuments = returnDocuments;
    }

    public RerankRequest rankFields(List<String> rankFields) {
        this.rankFields = rankFields;
        return this;
    }

    public RerankRequest addRankFieldsItem(String rankFieldsItem) {
        if (this.rankFields == null) {
            this.rankFields = new ArrayList<String>(Arrays.asList("text"));
        }
        this.rankFields.add(rankFieldsItem);
        return this;
    }

    @Nullable
    public List<String> getRankFields() {
        return this.rankFields;
    }

    public void setRankFields(List<String> rankFields) {
        this.rankFields = rankFields;
    }

    public RerankRequest documents(List<Map<String, Object>> documents) {
        this.documents = documents;
        return this;
    }

    public RerankRequest addDocumentsItem(Map<String, Object> documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Map<String, Object>>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nonnull
    public List<Map<String, Object>> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Map<String, Object>> documents) {
        this.documents = documents;
    }

    public RerankRequest parameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public RerankRequest putParametersItem(String key, Object parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public RerankRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerankRequest rerankRequest = (RerankRequest)o;
        return Objects.equals(this.model, rerankRequest.model) && Objects.equals(this.query, rerankRequest.query) && Objects.equals(this.topN, rerankRequest.topN) && Objects.equals(this.returnDocuments, rerankRequest.returnDocuments) && Objects.equals(this.rankFields, rerankRequest.rankFields) && Objects.equals(this.documents, rerankRequest.documents) && Objects.equals(this.parameters, rerankRequest.parameters) && Objects.equals(this.additionalProperties, rerankRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.query, this.topN, this.returnDocuments, this.rankFields, this.documents, this.parameters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RerankRequest {\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    topN: ").append(this.toIndentedString(this.topN)).append("\n");
        sb.append("    returnDocuments: ").append(this.toIndentedString(this.returnDocuments)).append("\n");
        sb.append("    rankFields: ").append(this.toIndentedString(this.rankFields)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in RerankRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_MODEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `model` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_QUERY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `query` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUERY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANK_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_RANK_FIELDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RANK_FIELDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `rank_fields` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANK_FIELDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCUMENTS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTS).toString()));
        }
    }

    public static RerankRequest fromJson(String jsonString) throws IOException {
        return (RerankRequest)JSON.getGson().fromJson(jsonString, RerankRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MODEL);
        openapiFields.add(SERIALIZED_NAME_QUERY);
        openapiFields.add(SERIALIZED_NAME_TOP_N);
        openapiFields.add(SERIALIZED_NAME_RETURN_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_RANK_FIELDS);
        openapiFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MODEL);
        openapiRequiredFields.add(SERIALIZED_NAME_QUERY);
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RerankRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RerankRequest.class));
            return new TypeAdapter<RerankRequest>(){

                public void write(JsonWriter out, RerankRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RerankRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    RerankRequest.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    RerankRequest instance = (RerankRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

