/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.clients;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Struct;
import io.pinecone.clients.Pinecone;
import io.pinecone.commons.IndexInterface;
import io.pinecone.configs.PineconeConfig;
import io.pinecone.configs.PineconeConnection;
import io.pinecone.exceptions.PineconeValidationException;
import io.pinecone.proto.DeleteNamespaceRequest;
import io.pinecone.proto.DeleteRequest;
import io.pinecone.proto.DeleteResponse;
import io.pinecone.proto.DescribeIndexStatsRequest;
import io.pinecone.proto.DescribeIndexStatsResponse;
import io.pinecone.proto.DescribeNamespaceRequest;
import io.pinecone.proto.FetchRequest;
import io.pinecone.proto.FetchResponse;
import io.pinecone.proto.ListNamespacesRequest;
import io.pinecone.proto.ListNamespacesResponse;
import io.pinecone.proto.ListRequest;
import io.pinecone.proto.ListResponse;
import io.pinecone.proto.NamespaceDescription;
import io.pinecone.proto.QueryRequest;
import io.pinecone.proto.QueryResponse;
import io.pinecone.proto.UpdateRequest;
import io.pinecone.proto.UpdateResponse;
import io.pinecone.proto.UpsertRequest;
import io.pinecone.proto.UpsertResponse;
import io.pinecone.proto.VectorServiceGrpc;
import io.pinecone.unsigned_indices_model.QueryResponseWithUnsignedIndices;
import io.pinecone.unsigned_indices_model.VectorWithUnsignedIndices;
import java.util.List;
import java.util.concurrent.Executor;
import okhttp3.OkHttpClient;
import org.openapitools.db_data.client.ApiClient;
import org.openapitools.db_data.client.ApiException;
import org.openapitools.db_data.client.api.BulkOperationsApi;
import org.openapitools.db_data.client.model.ImportErrorMode;
import org.openapitools.db_data.client.model.ImportModel;
import org.openapitools.db_data.client.model.ListImportsResponse;
import org.openapitools.db_data.client.model.StartImportRequest;
import org.openapitools.db_data.client.model.StartImportResponse;

public class AsyncIndex
implements IndexInterface<ListenableFuture<UpsertResponse>, ListenableFuture<QueryResponseWithUnsignedIndices>, ListenableFuture<FetchResponse>, ListenableFuture<UpdateResponse>, ListenableFuture<DeleteResponse>, ListenableFuture<DescribeIndexStatsResponse>, ListenableFuture<ListResponse>, ListenableFuture<ListNamespacesResponse>, ListenableFuture<NamespaceDescription>> {
    private final PineconeConnection connection;
    private final VectorServiceGrpc.VectorServiceFutureStub asyncStub;
    private final String indexName;
    BulkOperationsApi bulkOperations;

    public AsyncIndex(PineconeConfig config, PineconeConnection connection, String indexName) {
        if (connection == null) {
            throw new PineconeValidationException("Pinecone connection object cannot be null.");
        }
        this.indexName = indexName;
        this.connection = connection;
        this.asyncStub = connection.getAsyncStub();
        OkHttpClient customOkHttpClient = config.getCustomOkHttpClient();
        ApiClient apiClient = customOkHttpClient != null ? new ApiClient(customOkHttpClient) : new ApiClient(Pinecone.buildOkHttpClient(config.getProxyConfig()));
        apiClient.setApiKey(config.getApiKey());
        apiClient.setUserAgent(config.getUserAgent());
        apiClient.addDefaultHeader("X-Pinecone-Api-Version", "2025-04");
        this.bulkOperations = new BulkOperationsApi(apiClient);
        String protocol = config.isTLSEnabled() ? "https://" : "http://";
        this.bulkOperations.setCustomBaseUrl(protocol + config.getHost());
    }

    @Override
    public ListenableFuture<UpsertResponse> upsert(List<VectorWithUnsignedIndices> vectorList, String namespace) {
        UpsertRequest upsertRequest = this.validateUpsertRequest(vectorList, namespace);
        return this.asyncStub.upsert(upsertRequest);
    }

    @Override
    public ListenableFuture<UpsertResponse> upsert(String id, List<Float> values) {
        return this.upsert(id, values, null, null, null, null);
    }

    @Override
    public ListenableFuture<UpsertResponse> upsert(String id, List<Float> values, String namespace) {
        return this.upsert(id, values, null, null, null, namespace);
    }

    @Override
    public ListenableFuture<UpsertResponse> upsert(String id, List<Float> values, List<Long> sparseIndices, List<Float> sparseValues, Struct metadata, String namespace) {
        UpsertRequest upsertRequest = this.validateUpsertRequest(id, values, sparseIndices, sparseValues, metadata, namespace);
        return this.asyncStub.upsert(upsertRequest);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> query(int topK, List<Float> vector, List<Long> sparseIndices, List<Float> sparseValues, String id, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        QueryRequest queryRequest = this.validateQueryRequest(topK, vector, sparseIndices, sparseValues, id, namespace, filter, includeValues, includeMetadata);
        ListenableFuture<QueryResponse> queryResponseFuture = this.asyncStub.query(queryRequest);
        return Futures.transform(queryResponseFuture, QueryResponseWithUnsignedIndices::new, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVectorId(int topK, String id, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, null, null, null, id, namespace, filter, includeValues, includeMetadata);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVectorId(int topK, String id, String namespace, Struct filter) {
        return this.query(topK, null, null, null, id, namespace, filter, false, false);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVectorId(int topK, String id, String namespace, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, null, null, null, id, namespace, null, includeValues, includeMetadata);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVectorId(int topK, String id, String namespace) {
        return this.query(topK, null, null, null, id, namespace, null, false, false);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVectorId(int topK, String id, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, null, null, null, id, null, null, includeValues, includeMetadata);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVectorId(int topK, String id) {
        return this.query(topK, null, null, null, id, null, null, false, false);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVector(int topK, List<Float> vector, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, vector, null, null, null, namespace, filter, includeValues, includeMetadata);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVector(int topK, List<Float> vector, String namespace, Struct filter) {
        return this.query(topK, vector, null, null, null, namespace, filter, false, false);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVector(int topK, List<Float> vector, String namespace, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, vector, null, null, null, namespace, null, includeValues, includeMetadata);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVector(int topK, List<Float> vector, String namespace) {
        return this.query(topK, vector, null, null, null, namespace, null, false, false);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVector(int topK, List<Float> vector, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, vector, null, null, null, null, null, includeValues, includeMetadata);
    }

    @Override
    public ListenableFuture<QueryResponseWithUnsignedIndices> queryByVector(int topK, List<Float> vector) {
        return this.query(topK, vector, null, null, null, null, null, false, false);
    }

    @Override
    public ListenableFuture<FetchResponse> fetch(List<String> ids) {
        return this.fetch(ids, null);
    }

    @Override
    public ListenableFuture<FetchResponse> fetch(List<String> ids, String namespace) {
        FetchRequest fetchRequest = this.validateFetchRequest(ids, namespace);
        return this.asyncStub.fetch(fetchRequest);
    }

    @Override
    public ListenableFuture<UpdateResponse> update(String id, List<Float> values) {
        return this.update(id, values, null, null, null, null);
    }

    @Override
    public ListenableFuture<UpdateResponse> update(String id, List<Float> values, String namespace) {
        return this.update(id, values, null, namespace, null, null);
    }

    @Override
    public ListenableFuture<UpdateResponse> update(String id, List<Float> values, Struct metadata, String namespace, List<Long> sparseIndices, List<Float> sparseValues) {
        UpdateRequest updateRequest = this.validateUpdateRequest(id, values, metadata, namespace, sparseIndices, sparseValues);
        return this.asyncStub.update(updateRequest);
    }

    @Override
    public ListenableFuture<DeleteResponse> deleteByIds(List<String> ids, String namespace) {
        return this.delete(ids, false, namespace, null);
    }

    @Override
    public ListenableFuture<DeleteResponse> deleteByIds(List<String> ids) {
        return this.delete(ids, false, null, null);
    }

    @Override
    public ListenableFuture<DeleteResponse> deleteByFilter(Struct filter, String namespace) {
        return this.delete(null, false, namespace, filter);
    }

    @Override
    public ListenableFuture<DeleteResponse> deleteByFilter(Struct filter) {
        return this.delete(null, false, null, filter);
    }

    @Override
    public ListenableFuture<DeleteResponse> deleteAll(String namespace) {
        return this.delete(null, true, namespace, null);
    }

    @Override
    public ListenableFuture<DeleteResponse> delete(List<String> ids, boolean deleteAll, String namespace, Struct filter) {
        DeleteRequest deleteRequest = this.validateDeleteRequest(ids, deleteAll, namespace, filter);
        return this.asyncStub.delete(deleteRequest);
    }

    @Override
    public ListenableFuture<DescribeIndexStatsResponse> describeIndexStats() {
        DescribeIndexStatsRequest describeIndexStatsRequest = this.validateDescribeIndexStatsRequest(null);
        return this.asyncStub.describeIndexStats(describeIndexStatsRequest);
    }

    @Override
    public ListenableFuture<DescribeIndexStatsResponse> describeIndexStats(Struct filter) {
        DescribeIndexStatsRequest describeIndexStatsRequest = this.validateDescribeIndexStatsRequest(filter);
        return this.asyncStub.describeIndexStats(describeIndexStatsRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list() {
        this.validateListEndpointParameters(null, null, null, null, false, false, false, false);
        ListRequest listRequest = ListRequest.newBuilder().build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace) {
        this.validateListEndpointParameters(namespace, null, null, null, true, false, false, false);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace, int limit, String paginationToken) {
        this.validateListEndpointParameters(namespace, null, paginationToken, limit, true, false, true, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setLimit(limit).setPaginationToken(paginationToken).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace, int limit) {
        this.validateListEndpointParameters(namespace, null, null, limit, true, false, false, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setLimit(limit).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace, String prefix) {
        this.validateListEndpointParameters(namespace, prefix, null, null, true, true, false, false);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace, String prefix, int limit) {
        this.validateListEndpointParameters(namespace, prefix, null, limit, true, true, false, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).setLimit(limit).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace, String prefix, String paginationToken) {
        this.validateListEndpointParameters(namespace, prefix, paginationToken, null, true, true, true, false);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).setPaginationToken(paginationToken).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListResponse> list(String namespace, String prefix, String paginationToken, int limit) {
        this.validateListEndpointParameters(namespace, prefix, paginationToken, limit, true, true, true, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).setPaginationToken(paginationToken).setLimit(limit).build();
        return this.asyncStub.list(listRequest);
    }

    @Override
    public ListenableFuture<ListNamespacesResponse> listNamespaces() {
        ListNamespacesRequest listNamespacesRequest = ListNamespacesRequest.newBuilder().build();
        return this.asyncStub.listNamespaces(listNamespacesRequest);
    }

    @Override
    public ListenableFuture<ListNamespacesResponse> listNamespaces(String paginationToken) {
        ListNamespacesRequest listNamespacesRequest = ListNamespacesRequest.newBuilder().setPaginationToken(paginationToken).build();
        return this.asyncStub.listNamespaces(listNamespacesRequest);
    }

    @Override
    public ListenableFuture<ListNamespacesResponse> listNamespaces(String paginationToken, int limit) {
        ListNamespacesRequest.Builder listNamespacesRequest = ListNamespacesRequest.newBuilder().setLimit(limit);
        if (paginationToken != null) {
            listNamespacesRequest.setPaginationToken(paginationToken);
        }
        return this.asyncStub.listNamespaces(listNamespacesRequest.build());
    }

    @Override
    public ListenableFuture<NamespaceDescription> describeNamespace(String namespace) {
        DescribeNamespaceRequest describeNamespaceRequest = DescribeNamespaceRequest.newBuilder().setNamespace(namespace).build();
        return this.asyncStub.describeNamespace(describeNamespaceRequest);
    }

    @Override
    public ListenableFuture<DeleteResponse> deleteNamespace(String namespace) {
        DeleteNamespaceRequest deleteNamespaceRequest = DeleteNamespaceRequest.newBuilder().setNamespace(namespace).build();
        return this.asyncStub.deleteNamespace(deleteNamespaceRequest);
    }

    public StartImportResponse startImport(String uri, String integrationId, ImportErrorMode.OnErrorEnum errorMode) throws ApiException {
        StartImportRequest importRequest = new StartImportRequest();
        importRequest.setUri(uri);
        if (integrationId != null && !integrationId.isEmpty()) {
            importRequest.setIntegrationId(integrationId);
        }
        if (errorMode != null) {
            ImportErrorMode importErrorMode = new ImportErrorMode().onError(errorMode);
            importRequest.setErrorMode(importErrorMode);
        }
        return this.bulkOperations.startBulkImport(importRequest);
    }

    public ListImportsResponse listImports() throws ApiException {
        return this.listImports(100, null);
    }

    public ListImportsResponse listImports(Integer limit) throws ApiException {
        return this.listImports(limit, null);
    }

    public ListImportsResponse listImports(Integer limit, String paginationToken) throws ApiException {
        return this.bulkOperations.listBulkImports(limit, paginationToken);
    }

    public ImportModel describeImport(String id) throws ApiException {
        return this.bulkOperations.describeBulkImport(id);
    }

    public void cancelImport(String id) throws ApiException {
        this.bulkOperations.cancelBulkImport(id);
    }

    @Override
    public void close() {
        Pinecone.closeConnection(this.indexName);
        this.connection.close();
    }
}

