/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java9;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.MarkRecorderRef;
import io.perfmark.impl.Storage;
import io.perfmark.impl.ThreadInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

final class VarHandleMarkHolder
extends MarkHolder {
    private static final long GEN_MASK = 255L;
    private static final long START_OP = 1L;
    private static final long START_S_OP = 2L;
    private static final long START_T_OP = 3L;
    private static final long STOP_OP = 4L;
    private static final long STOP_V_OP = 5L;
    private static final long STOP_T_OP = 6L;
    private static final long STOP_S_OP = 7L;
    private static final long EVENT_OP = 8L;
    private static final long EVENT_T_OP = 9L;
    private static final long EVENT_S_OP = 10L;
    private static final long LINK_OP = 11L;
    private static final long ATTACH_T_OP = 12L;
    private static final long ATTACH_SS_OP = 13L;
    private static final long ATTACH_SN_OP = 14L;
    private static final long ATTACH_SNN_OP = 15L;
    private static final VarHandle IDX;
    private static final VarHandle STRINGS;
    private static final VarHandle LONGS;
    private final MarkRecorderRef markRecorderRef;
    private final int maxEvents;
    private final long maxEventsMax;
    private volatile long idx;
    private final String[] taskNames;
    private final String[] tagNames;
    private final long[] tagIds;
    private final long[] nanoTimes;
    private final long[] genOps;

    VarHandleMarkHolder(MarkRecorderRef markRecorderRef) {
        this(markRecorderRef, 32768);
    }

    VarHandleMarkHolder(MarkRecorderRef markRecorderRef, int maxEvents) {
        if ((maxEvents - 1 & maxEvents) != 0) {
            throw new IllegalArgumentException(maxEvents + " is not a power of two");
        }
        if (maxEvents <= 0) {
            throw new IllegalArgumentException(maxEvents + " is not positive");
        }
        this.markRecorderRef = markRecorderRef;
        this.maxEvents = maxEvents;
        this.maxEventsMax = (long)maxEvents - 1L;
        this.taskNames = new String[maxEvents];
        this.tagNames = new String[maxEvents];
        this.tagIds = new long[maxEvents];
        this.nanoTimes = new long[maxEvents];
        this.genOps = new long[maxEvents];
    }

    void startAt(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, taskName);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 3L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void startAt(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, taskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 1L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void startAt(long gen, String taskName, String subTaskName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, taskName);
        STRINGS.setOpaque(this.tagNames, i, subTaskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 2L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void link(long gen, long linkId) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        LONGS.setOpaque(this.tagIds, i, linkId);
        LONGS.setOpaque(this.genOps, i, gen + 11L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void stopAt(long gen, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 5L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void stopAt(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, taskName);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 6L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void stopAt(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, taskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 4L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void stopAt(long gen, String taskName, String subTaskName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, taskName);
        STRINGS.setOpaque(this.tagNames, i, subTaskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 7L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void eventAt(long gen, String eventName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, eventName);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 9L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void eventAt(long gen, String eventName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, eventName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 8L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void eventAt(long gen, String eventName, String subEventName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.taskNames, i, eventName);
        STRINGS.setOpaque(this.tagNames, i, subEventName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + 10L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void attachTag(long gen, String tagName, long tagId) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.genOps, i, gen + 12L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void attachKeyedTag(long gen, String name, long value) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.tagNames, i, name);
        LONGS.setOpaque(this.tagIds, i, value);
        LONGS.setOpaque(this.genOps, i, gen + 14L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void attachKeyedTag(long gen, String name, long value0, long value1) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.tagNames, i, name);
        LONGS.setOpaque(this.tagIds, i, value0);
        LONGS.setOpaque(this.nanoTimes, i, value1);
        LONGS.setOpaque(this.genOps, i, gen + 15L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    void attachKeyedTag(long gen, String name, String value) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.tagNames, i, name);
        STRINGS.setOpaque(this.taskNames, i, value);
        LONGS.setOpaque(this.genOps, i, gen + 13L);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void resetForAll() {
        this.resetForThread();
    }

    public List<MarkList> read() {
        ThreadInfo threadInfo = this.markRecorderRef.threadInfo();
        List<Mark> marks = this.read(!threadInfo.isTerminated() && !threadInfo.isCurrentThread());
        if (marks.isEmpty()) {
            return Collections.emptyList();
        }
        return List.of(MarkList.newBuilder().setMarks(marks).setThreadId(threadInfo.getId()).setThreadName(threadInfo.getName()).setMarkRecorderId(this.markRecorderRef.markRecorderId()).build());
    }

    public void resetForThread() {
        if (this.markRecorderRef.threadInfo().isTerminated()) {
            Storage.unregisterMarkHolder((MarkHolder)this);
        }
        if (!this.markRecorderRef.threadInfo().isCurrentThread()) {
            return;
        }
        Arrays.fill(this.taskNames, null);
        Arrays.fill(this.tagNames, null);
        Arrays.fill(this.tagIds, 0L);
        Arrays.fill(this.nanoTimes, 0L);
        Arrays.fill(this.genOps, 0L);
        IDX.setRelease(this, 0L);
        VarHandle.storeStoreFence();
    }

    private List<Mark> read(boolean concurrentWrites) {
        String[] localTaskNames = new String[this.maxEvents];
        String[] localTagNames = new String[this.maxEvents];
        long[] localTagIds = new long[this.maxEvents];
        long[] localNanoTimes = new long[this.maxEvents];
        long[] localGenOps = new long[this.maxEvents];
        long startIdx = IDX.getOpaque(this);
        VarHandle.loadLoadFence();
        int size = (int)Math.min(startIdx, (long)this.maxEvents);
        for (int i = 0; i < size; ++i) {
            localTaskNames[i] = STRINGS.getOpaque(this.taskNames, i);
            localTagNames[i] = STRINGS.getOpaque(this.tagNames, i);
            localTagIds[i] = LONGS.getOpaque(this.tagIds, i);
            localNanoTimes[i] = LONGS.getOpaque(this.nanoTimes, i);
            localGenOps[i] = LONGS.getOpaque(this.genOps, i);
        }
        VarHandle.loadLoadFence();
        long endIdx = IDX.getOpaque(this);
        if (endIdx < startIdx) {
            throw new AssertionError();
        }
        boolean tailValid = !concurrentWrites || endIdx < (long)(this.maxEvents - 1);
        long eventsToDrop = (endIdx += !tailValid ? 1L : 0L) - startIdx;
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(size);
        int i = 0;
        while ((long)i < (long)size - eventsToDrop) {
            int readIdx = (int)(startIdx - (long)i - 1L & this.maxEventsMax);
            long gen = localGenOps[readIdx] & 0xFFFFFFFFFFFFFF00L;
            int opVal = (int)(localGenOps[readIdx] & 0xFFL);
            switch (opVal) {
                case 3: {
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                }
                case 1: {
                    marks.addFirst(Mark.taskStart((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 2: {
                    marks.addFirst(Mark.taskStart((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 5: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx]));
                    break;
                }
                case 7: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 4: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 6: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 8: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 9: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 10: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 11: {
                    marks.addFirst(Mark.link((long)gen, (long)localTagIds[readIdx]));
                    break;
                }
                case 12: {
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 13: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 14: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 15: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx], (long)localNanoTimes[readIdx]));
                    break;
                }
                default: {
                    throw new ConcurrentModificationException("Read of storage was not threadsafe " + opVal);
                }
            }
            ++i;
        }
        return Collections.unmodifiableList(new ArrayList(marks));
    }

    public int maxMarks() {
        return this.maxEvents;
    }

    static {
        try {
            IDX = MethodHandles.lookup().findVarHandle(VarHandleMarkHolder.class, "idx", Long.TYPE);
            STRINGS = MethodHandles.arrayElementVarHandle(String[].class);
            LONGS = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

