/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java6;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.Marker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class SynchronizedMarkHolder
extends MarkHolder {
    private static final long START_OP = Mark.Operation.TASK_START.ordinal();
    private static final long START_T_OP = Mark.Operation.TASK_START_T.ordinal();
    private static final long START_M_OP = Mark.Operation.TASK_START_M.ordinal();
    private static final long START_TM_OP = Mark.Operation.TASK_START_TM.ordinal();
    private static final long STOP_OP = Mark.Operation.TASK_END.ordinal();
    private static final long STOP_T_OP = Mark.Operation.TASK_END_T.ordinal();
    private static final long STOP_M_OP = Mark.Operation.TASK_END_M.ordinal();
    private static final long STOP_TM_OP = Mark.Operation.TASK_END_TM.ordinal();
    private static final long EVENT_OP = Mark.Operation.EVENT.ordinal();
    private static final long EVENT_T_OP = Mark.Operation.EVENT_T.ordinal();
    private static final long EVENT_M_OP = Mark.Operation.EVENT_M.ordinal();
    private static final long EVENT_TM_OP = Mark.Operation.EVENT_TM.ordinal();
    private static final long LINK_OP = Mark.Operation.LINK.ordinal();
    private static final long LINK_M_OP = Mark.Operation.LINK_M.ordinal();
    private static final long ATTACH_T_OP = Mark.Operation.ATTACH_TAG.ordinal();
    private final int maxEvents;
    private int idx;
    private final String[] taskNames;
    private final Marker[] markers;
    private final String[] tagNames;
    private final long[] tagIds;
    private final long[] nanoTimes;
    private final long[] durationNanoTimes;
    private final long[] genOps;

    SynchronizedMarkHolder() {
        this(32768);
    }

    SynchronizedMarkHolder(int maxEvents) {
        if ((maxEvents - 1 & maxEvents) != 0) {
            throw new IllegalArgumentException(maxEvents + " is not a power of two");
        }
        if (maxEvents <= 0) {
            throw new IllegalArgumentException(maxEvents + " is not positive");
        }
        this.maxEvents = maxEvents;
        this.taskNames = new String[maxEvents];
        this.markers = new Marker[maxEvents];
        this.tagNames = new String[maxEvents];
        this.tagIds = new long[maxEvents];
        this.nanoTimes = new long[maxEvents];
        this.durationNanoTimes = new long[maxEvents];
        this.genOps = new long[maxEvents];
    }

    public synchronized void start(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + START_T_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void start(long gen, String taskName, Marker marker, String tagName, long tagId, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.markers[this.idx] = marker;
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + START_TM_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void start(long gen, String taskName, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + START_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void start(long gen, String taskName, Marker marker, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.markers[this.idx] = marker;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + START_M_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void link(long gen, long linkId) {
        this.nanoTimes[this.idx] = 0L;
        this.tagIds[this.idx] = linkId;
        this.genOps[this.idx] = gen + LINK_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void link(long gen, long linkId, Marker marker) {
        this.markers[this.idx] = marker;
        this.nanoTimes[this.idx] = 0L;
        this.tagIds[this.idx] = linkId;
        this.genOps[this.idx] = gen + LINK_M_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void stop(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + STOP_T_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void stop(long gen, String taskName, Marker marker, String tagName, long tagId, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.markers[this.idx] = marker;
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + STOP_TM_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void stop(long gen, String taskName, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + STOP_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void stop(long gen, String taskName, Marker marker, long nanoTime) {
        this.taskNames[this.idx] = taskName;
        this.markers[this.idx] = marker;
        this.nanoTimes[this.idx] = nanoTime;
        this.genOps[this.idx] = gen + STOP_M_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void event(long gen, String eventName, String tagName, long tagId, long nanoTime, long durationNanos) {
        this.taskNames[this.idx] = eventName;
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.nanoTimes[this.idx] = nanoTime;
        this.durationNanoTimes[this.idx] = durationNanos;
        this.genOps[this.idx] = gen + EVENT_T_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void event(long gen, String taskName, Marker marker, String tagName, long tagId, long nanoTime, long durationNanos) {
        this.taskNames[this.idx] = taskName;
        this.markers[this.idx] = marker;
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.nanoTimes[this.idx] = nanoTime;
        this.durationNanoTimes[this.idx] = durationNanos;
        this.genOps[this.idx] = gen + EVENT_TM_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void event(long gen, String eventName, long nanoTime, long durationNanos) {
        this.taskNames[this.idx] = eventName;
        this.nanoTimes[this.idx] = nanoTime;
        this.durationNanoTimes[this.idx] = durationNanos;
        this.genOps[this.idx] = gen + EVENT_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void event(long gen, String eventName, Marker marker, long nanoTime, long durationNanos) {
        this.taskNames[this.idx] = eventName;
        this.markers[this.idx] = marker;
        this.nanoTimes[this.idx] = nanoTime;
        this.durationNanoTimes[this.idx] = durationNanos;
        this.genOps[this.idx] = gen + EVENT_M_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void attachTag(long gen, String tagName, long tagId) {
        this.tagNames[this.idx] = tagName;
        this.tagIds[this.idx] = tagId;
        this.genOps[this.idx] = gen + ATTACH_T_OP;
        if (++this.idx == this.maxEvents) {
            this.idx = 0;
        }
    }

    public synchronized void resetForTest() {
        Arrays.fill(this.taskNames, null);
        Arrays.fill(this.markers, null);
        Arrays.fill(this.tagNames, null);
        Arrays.fill(this.tagIds, 0L);
        Arrays.fill(this.nanoTimes, 0L);
        Arrays.fill(this.durationNanoTimes, 0L);
        Arrays.fill(this.genOps, 0L);
        this.idx = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Mark> read(boolean concurrentWrites) {
        int localIdx;
        String[] localTaskNames = new String[this.maxEvents];
        Marker[] localMarkers = new Marker[this.maxEvents];
        String[] localTagNames = new String[this.maxEvents];
        long[] localTagIds = new long[this.maxEvents];
        long[] localNanoTimes = new long[this.maxEvents];
        long[] localGenOps = new long[this.maxEvents];
        SynchronizedMarkHolder synchronizedMarkHolder = this;
        synchronized (synchronizedMarkHolder) {
            System.arraycopy(this.taskNames, 0, localTaskNames, 0, this.maxEvents);
            System.arraycopy(this.markers, 0, localMarkers, 0, this.maxEvents);
            System.arraycopy(this.tagNames, 0, localTagNames, 0, this.maxEvents);
            System.arraycopy(this.tagIds, 0, localTagIds, 0, this.maxEvents);
            System.arraycopy(this.nanoTimes, 0, localNanoTimes, 0, this.maxEvents);
            System.arraycopy(this.genOps, 0, localGenOps, 0, this.maxEvents);
            localIdx = this.idx;
        }
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(this.maxEvents);
        for (int i = 0; i < this.maxEvents; ++i) {
            if (localIdx-- == 0) {
                localIdx += this.maxEvents;
            }
            long gen = localGenOps[localIdx] & 0xFFFFFFFFFFFFFF00L;
            Mark.Operation op = Mark.Operation.valueOf((int)((int)(localGenOps[localIdx] & 0xFFL)));
            if (op == Mark.Operation.NONE) break;
            marks.addFirst(Mark.create((String)localTaskNames[localIdx], (Marker)localMarkers[localIdx], (String)localTagNames[localIdx], (long)localTagIds[localIdx], (long)localNanoTimes[localIdx], (long)gen, (Mark.Operation)op));
        }
        return Collections.unmodifiableList(new ArrayList(marks));
    }

    public int maxMarks() {
        return this.maxEvents;
    }
}

