/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.ThreadInfo;
import io.perfmark.impl.ThreadRef;

final class ThreadRefInfo
extends ThreadInfo {
    private final ThreadRef threadRef;
    private volatile String threadName;
    private volatile long threadId;

    ThreadRefInfo(ThreadRef threadRef) {
        this.threadRef = threadRef;
        Thread thread = (Thread)threadRef.get();
        if (thread == null) {
            throw new IllegalArgumentException("can't use terminated thread");
        }
        this.threadName = thread.getName();
        this.threadId = thread.getId();
    }

    @Override
    public String getName() {
        String localThreadName = this.threadName;
        Thread t = (Thread)this.threadRef.get();
        if (t == null) {
            return localThreadName;
        }
        localThreadName = this.maybeUpdateThreadName(t.getName(), localThreadName);
        if (t.getState() == Thread.State.TERMINATED) {
            this.maybeUpdateThreadId(t.getId(), this.threadId);
            this.threadRef.enqueueSafe();
        }
        return localThreadName;
    }

    @Override
    public long getId() {
        long localThreadId = this.threadId;
        Thread t = (Thread)this.threadRef.get();
        if (t == null) {
            return localThreadId;
        }
        localThreadId = this.maybeUpdateThreadId(t.getId(), localThreadId);
        if (t.getState() == Thread.State.TERMINATED) {
            this.maybeUpdateThreadName(t.getName(), this.threadName);
            this.threadRef.enqueueSafe();
        }
        return localThreadId;
    }

    private String maybeUpdateThreadName(String tName, String localThreadName) {
        if (!tName.equals(localThreadName)) {
            this.threadName = tName;
            return tName;
        }
        return localThreadName;
    }

    private long maybeUpdateThreadId(long threadId, long localThreadId) {
        if (localThreadId != threadId) {
            this.threadId = threadId;
            return threadId;
        }
        return localThreadId;
    }

    @Override
    public boolean isTerminated() {
        Thread t = (Thread)this.threadRef.get();
        return t == null || t.getState() == Thread.State.TERMINATED;
    }

    @Override
    public boolean isCurrentThread() {
        Thread t = (Thread)this.threadRef.get();
        return t == Thread.currentThread();
    }
}

