/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.Mark;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public final class MarkList
extends AbstractList<Mark> {
    private final List<Mark> marks;
    private final long threadId;
    private final long markRecorderId;
    private final String threadName;

    public static Builder newBuilder() {
        return new Builder();
    }

    MarkList(Builder builder) {
        if (builder.marks == null) {
            throw new NullPointerException("marks");
        }
        this.marks = builder.marks;
        if (builder.threadName == null) {
            throw new NullPointerException("threadName");
        }
        this.threadName = builder.threadName;
        this.threadId = builder.threadId;
        this.markRecorderId = builder.markRecorderId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getMarkRecorderId() {
        return this.markRecorderId;
    }

    @Override
    public Mark get(int index) {
        return this.marks.get(index);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MarkList)) {
            return false;
        }
        MarkList that = (MarkList)obj;
        return Mark.equal(this.marks, that.marks) && this.threadId == that.threadId && this.markRecorderId == that.markRecorderId && Mark.equal(this.threadName, that.threadName);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.marks, this.threadId, this.markRecorderId, this.threadName});
    }

    @Override
    public int size() {
        return this.marks.size();
    }

    @Override
    public String toString() {
        return "MarkList{marks=" + this.marks + ", threadId=" + this.threadId + ", markRecorderId=" + this.markRecorderId + ", threadName=" + this.threadName + "}";
    }

    public Builder toBuilder() {
        Builder builder = MarkList.newBuilder();
        builder.marks = this.marks;
        return builder.setThreadName(this.threadName).setThreadId(this.threadId).setMarkRecorderId(this.markRecorderId);
    }

    public static final class Builder {
        List<Mark> marks;
        String threadName;
        long threadId;
        long markRecorderId;

        public MarkList build() {
            return new MarkList(this);
        }

        public Builder setMarks(List<Mark> marks) {
            if (marks == null) {
                throw new NullPointerException("marks");
            }
            ArrayList<Mark> copy = new ArrayList<Mark>(marks.size());
            ListIterator<Mark> it = marks.listIterator();
            while (it.hasNext()) {
                Mark mark = it.next();
                if (mark == null) {
                    throw new NullPointerException("mark is null at pos " + (it.nextIndex() - 1));
                }
                copy.add(mark);
            }
            this.marks = Collections.unmodifiableList(copy);
            return this;
        }

        public Builder setThreadName(String threadName) {
            this.threadName = threadName;
            return this;
        }

        public Builder setThreadId(long threadId) {
            this.threadId = threadId;
            return this;
        }

        public Builder setMarkRecorderId(long markRecorderId) {
            this.markRecorderId = markRecorderId;
            return this;
        }
    }
}

