/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.Storage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class MostlyThreadLocal
extends ThreadLocal<MarkHolder> {
    private static final int BITS = 11;
    private static final int SIZE = 2048;
    private static final int MASK = 2047;
    private static final AtomicReferenceArray<CopyOnWriteArrayList<Storage.MarkHolderHandle>> threadToHandles = new AtomicReferenceArray(2048);

    MostlyThreadLocal() {
    }

    @Override
    public MarkHolder get() {
        MarkHolder markHolder = (MarkHolder)super.get();
        if (markHolder != null) {
            return markHolder;
        }
        return this.getAndSetSlow();
    }

    private MarkHolder getAndSetSlow() {
        Storage.MarkHolderHandle markHolderHandle;
        MarkHolder markHolder;
        assert (super.get() == null);
        Thread thread = Thread.currentThread();
        CopyOnWriteArrayList<Storage.MarkHolderHandle> handles = MostlyThreadLocal.getHandles(thread);
        if (handles == null) {
            Storage.MarkHolderAndHandle markHolderAndHandle = Storage.allocateMarkHolder();
            markHolder = markHolderAndHandle.markHolder();
            assert (markHolder != null);
            markHolderHandle = markHolderAndHandle.handle();
            try {
                this.set(markHolder);
                return markHolder;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                handles = MostlyThreadLocal.getOrCreateHandles(thread);
            }
        } else {
            markHolderHandle = MostlyThreadLocal.getConcurrent(handles);
            if (markHolderHandle != null && (markHolder = markHolderHandle.markHolder()) != null) {
                return markHolder;
            }
            Storage.MarkHolderAndHandle markHolderAndHandle = Storage.allocateMarkHolder();
            markHolder = markHolderAndHandle.markHolder();
            assert (markHolder != null);
            markHolderHandle = markHolderAndHandle.handle();
        }
        handles.add(markHolderHandle);
        return markHolder;
    }

    @Override
    public void remove() {
        Thread thread = Thread.currentThread();
        CopyOnWriteArrayList<Storage.MarkHolderHandle> handles = MostlyThreadLocal.getHandles(thread);
        if (handles == null) {
            super.remove();
        } else {
            assert (super.get() == null);
            for (Storage.MarkHolderHandle handle : handles) {
                Thread t = (Thread)handle.threadRef().get();
                if (t != null && t != thread) continue;
                handles.remove(handle);
            }
        }
    }

    private static CopyOnWriteArrayList<Storage.MarkHolderHandle> getHandles(Thread thread) {
        int hashCode = System.identityHashCode(thread);
        int index = hashCode & 0x7FF;
        return threadToHandles.get(index);
    }

    private static CopyOnWriteArrayList<Storage.MarkHolderHandle> getOrCreateHandles(Thread thread) {
        CopyOnWriteArrayList<Storage.MarkHolderHandle> handles;
        int hashCode = System.identityHashCode(thread);
        int index = hashCode & 0x7FF;
        while ((handles = threadToHandles.get(index)) == null && !threadToHandles.compareAndSet(index, null, handles = new CopyOnWriteArrayList())) {
        }
        return handles;
    }

    private static Storage.MarkHolderHandle getConcurrent(CopyOnWriteArrayList<Storage.MarkHolderHandle> handles) {
        if (!handles.isEmpty()) {
            Storage.MarkHolderHandle handle;
            try {
                handle = handles.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            if (handle.threadRef().get() == Thread.currentThread()) {
                return handle;
            }
            return MostlyThreadLocal.slowGetConcurrent(handles);
        }
        return null;
    }

    private static Storage.MarkHolderHandle slowGetConcurrent(CopyOnWriteArrayList<Storage.MarkHolderHandle> handles) {
        for (Storage.MarkHolderHandle handle : handles) {
            Thread thread = (Thread)handle.threadRef().get();
            if (thread == null) {
                handles.remove(handle);
                continue;
            }
            if (thread != Thread.currentThread()) continue;
            return handle;
        }
        return null;
    }
}

