/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_DecisionImpl;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_Probability;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.attributes.DoubleAttributeSetter;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Samplers {
    private static final Sampler.Decision EMPTY_SAMPLED_DECISION = DecisionImpl.createWithoutAttributes(true);
    private static final Sampler.Decision EMPTY_NOT_SAMPLED_DECISION = DecisionImpl.createWithoutAttributes(false);
    static final DoubleAttributeSetter SAMPLING_PROBABILITY = DoubleAttributeSetter.create((String)"sampling.probability");

    private Samplers() {
    }

    public static Sampler.Decision decision(boolean isSampled, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? Samplers.emptyDecision(isSampled) : DecisionImpl.create(isSampled, attributes);
    }

    public static Sampler.Decision emptyDecision(boolean isSampled) {
        return isSampled ? EMPTY_SAMPLED_DECISION : EMPTY_NOT_SAMPLED_DECISION;
    }

    public static Sampler alwaysOn() {
        return AlwaysOnSampler.INSTANCE;
    }

    public static Sampler alwaysOff() {
        return AlwaysOffSampler.INSTANCE;
    }

    public static Sampler probability(double probability) {
        return Probability.create(probability);
    }

    @Immutable
    @AutoValue
    static abstract class DecisionImpl
    implements Sampler.Decision {
        DecisionImpl() {
        }

        static Sampler.Decision createWithProbability(boolean decision, double probability) {
            return new AutoValue_Samplers_DecisionImpl(decision, Attributes.of((String)SAMPLING_PROBABILITY.key(), (AttributeValue)AttributeValue.doubleAttributeValue((double)probability)));
        }

        static Sampler.Decision createWithoutAttributes(boolean decision) {
            return new AutoValue_Samplers_DecisionImpl(decision, Attributes.empty());
        }

        static Sampler.Decision create(boolean decision, Attributes attributes) {
            return new AutoValue_Samplers_DecisionImpl(decision, attributes);
        }

        @Override
        public abstract boolean isSampled();

        @Override
        public abstract Attributes getAttributes();
    }

    @AutoValue
    @Immutable
    static abstract class Probability
    implements Sampler {
        Probability() {
        }

        static Probability create(double probability) {
            Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (Object)"probability must be in range [0.0, 1.0]");
            long idUpperBound = probability == 0.0 ? Long.MIN_VALUE : (probability == 1.0 ? Long.MAX_VALUE : (long)(probability * 9.223372036854776E18));
            return new AutoValue_Samplers_Probability(probability, idUpperBound, DecisionImpl.createWithProbability(true, probability), DecisionImpl.createWithProbability(false, probability));
        }

        abstract double getProbability();

        abstract long getIdUpperBound();

        abstract Sampler.Decision getPositiveDecision();

        abstract Sampler.Decision getNegativeDecision();

        @Override
        public final Sampler.Decision shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, @Nullable List<Link> parentLinks) {
            if (parentContext != null && parentContext.getTraceFlags().isSampled()) {
                return EMPTY_SAMPLED_DECISION;
            }
            if (parentLinks != null) {
                for (Link parentLink : parentLinks) {
                    if (!parentLink.getContext().getTraceFlags().isSampled()) continue;
                    return EMPTY_SAMPLED_DECISION;
                }
            }
            return Math.abs(traceId.getTraceRandomPart()) < this.getIdUpperBound() ? this.getPositiveDecision() : this.getNegativeDecision();
        }

        @Override
        public final String getDescription() {
            return String.format("ProbabilitySampler{%.6f}", this.getProbability());
        }
    }

    @Immutable
    private static enum AlwaysOffSampler implements Sampler
    {
        INSTANCE;


        @Override
        public Sampler.Decision shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<Link> parentLinks) {
            return EMPTY_NOT_SAMPLED_DECISION;
        }

        @Override
        public String getDescription() {
            return "AlwaysOffSampler";
        }
    }

    @Immutable
    private static enum AlwaysOnSampler implements Sampler
    {
        INSTANCE;


        @Override
        public Sampler.Decision shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<Link> parentLinks) {
            return EMPTY_SAMPLED_DECISION;
        }

        @Override
        public String getDescription() {
            return "AlwaysOnSampler";
        }
    }
}

