/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.NoopAggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Batchers {
    static Batcher getNoop() {
        return Noop.INSTANCE;
    }

    static Batcher getCumulativeAllLabels(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation defaultAggregation) {
        return new AllLabels(Batchers.getDefaultMetricDescriptor(descriptor, defaultAggregation), meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), defaultAggregation.getAggregatorFactory(descriptor.getValueType()), meterProviderSharedState.getClock(), false);
    }

    static Batcher getDeltaAllLabels(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation defaultAggregation) {
        return new AllLabels(Batchers.getDefaultMetricDescriptor(descriptor, defaultAggregation), meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), defaultAggregation.getAggregatorFactory(descriptor.getValueType()), meterProviderSharedState.getClock(), true);
    }

    private static MetricData.Descriptor getDefaultMetricDescriptor(InstrumentDescriptor descriptor, Aggregation aggregation) {
        return MetricData.Descriptor.create(descriptor.getName(), descriptor.getDescription(), aggregation.getUnit(descriptor.getUnit()), aggregation.getDescriptorType(descriptor.getType(), descriptor.getValueType()), descriptor.getConstantLabels());
    }

    private Batchers() {
    }

    private static final class AllLabels
    implements Batcher {
        private final MetricData.Descriptor descriptor;
        private final Resource resource;
        private final InstrumentationLibraryInfo instrumentationLibraryInfo;
        private final Clock clock;
        private final AggregatorFactory aggregatorFactory;
        private Map<Labels, Aggregator> aggregatorMap;
        private long startEpochNanos;
        private final boolean delta;

        private AllLabels(MetricData.Descriptor descriptor, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, AggregatorFactory aggregatorFactory, Clock clock, boolean delta) {
            this.descriptor = descriptor;
            this.resource = resource;
            this.instrumentationLibraryInfo = instrumentationLibraryInfo;
            this.clock = clock;
            this.aggregatorFactory = aggregatorFactory;
            this.delta = delta;
            this.aggregatorMap = new HashMap<Labels, Aggregator>();
            this.startEpochNanos = clock.now();
        }

        @Override
        public final Aggregator getAggregator() {
            return this.aggregatorFactory.getAggregator();
        }

        @Override
        public final void batch(Labels labelSet, Aggregator aggregator, boolean unmappedAggregator) {
            Aggregator currentAggregator = this.aggregatorMap.get(labelSet);
            if (currentAggregator == null) {
                if (unmappedAggregator) {
                    this.aggregatorMap.put(labelSet, aggregator);
                    return;
                }
                currentAggregator = this.aggregatorFactory.getAggregator();
                this.aggregatorMap.put(labelSet, currentAggregator);
            }
            aggregator.mergeToAndReset(currentAggregator);
        }

        @Override
        public final List<MetricData> completeCollectionCycle() {
            ArrayList<MetricData.Point> points = new ArrayList<MetricData.Point>(this.aggregatorMap.size());
            long epochNanos = this.clock.now();
            for (Map.Entry<Labels, Aggregator> entry : this.aggregatorMap.entrySet()) {
                MetricData.Point point = entry.getValue().toPoint(this.startEpochNanos, epochNanos, entry.getKey());
                if (point == null) continue;
                points.add(point);
            }
            if (this.delta) {
                this.startEpochNanos = epochNanos;
                this.aggregatorMap = new HashMap<Labels, Aggregator>();
            }
            return Collections.singletonList(MetricData.create(this.descriptor, this.resource, this.instrumentationLibraryInfo, points));
        }
    }

    private static final class Noop
    implements Batcher {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public Aggregator getAggregator() {
            return NoopAggregator.getFactory().getAggregator();
        }

        @Override
        public void batch(Labels labelSet, Aggregator aggregator, boolean mappedAggregator) {
        }

        @Override
        public List<MetricData> completeCollectionCycle() {
            return Collections.emptyList();
        }
    }
}

