/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.AutoValue_SimpleSpansProcessor_Config;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.nashorn.internal.ir.annotations.Immutable;

public final class SimpleSpansProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(SimpleSpansProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean sampled;

    private SimpleSpansProcessor(SpanExporter spanExporter, boolean sampled) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        this.sampled = sampled;
    }

    public static SimpleSpansProcessor create(SpanExporter spanExporter) {
        return SimpleSpansProcessor.create(spanExporter, Config.getDefault());
    }

    public static SimpleSpansProcessor create(SpanExporter spanExporter, Config config) {
        return new SimpleSpansProcessor(spanExporter, config.isExportOnlySampled());
    }

    @Override
    public void onStart(ReadableSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().getTraceFlags().isSampled()) {
            return;
        }
        try {
            List<SpanData> spans = Collections.singletonList(span.toSpanData());
            this.spanExporter.export(spans);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception thrown by the export.", e);
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public void shutdown() {
        this.spanExporter.shutdown();
    }

    @Override
    public void forceFlush() {
    }

    @Immutable
    @AutoValue
    public static abstract class Config {
        private static final boolean DEFAULT_EXPORT_ONLY_SAMPLED = true;

        public abstract boolean isExportOnlySampled();

        public static Config getDefault() {
            return Config.newBuilder().build();
        }

        public static Config loadFromDefaultSources() {
            return Config.newBuilder().readEnvironment().readSystemProperties().build();
        }

        public static Builder newBuilder() {
            return new AutoValue_SimpleSpansProcessor_Config.Builder().setExportOnlySampled(true);
        }

        @AutoValue.Builder
        public static abstract class Builder
        extends ConfigBuilder<Builder> {
            private static final String KEY_SAMPLED = "otel.ssp.export.sampled";

            @Override
            @VisibleForTesting
            protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
                Boolean boolValue = Builder.getBooleanProperty(KEY_SAMPLED, configMap = namingConvention.normalize(configMap));
                if (boolValue != null) {
                    this.setExportOnlySampled(boolValue);
                }
                return this;
            }

            @Override
            public Builder readProperties(Properties properties) {
                return (Builder)super.readProperties(properties);
            }

            @Override
            public Builder readEnvironment() {
                return (Builder)super.readEnvironment();
            }

            @Override
            public Builder readSystemProperties() {
                return (Builder)super.readSystemProperties();
            }

            public abstract Builder setExportOnlySampled(boolean var1);

            abstract Config build();
        }
    }
}

