/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.sdk.trace.AutoValue_TimedEvent_RawTimedEvent;
import io.opentelemetry.sdk.trace.AutoValue_TimedEvent_RawTimedEventWithEvent;
import io.opentelemetry.trace.Event;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class TimedEvent {
    private static final Map<String, AttributeValue> EMPTY_ATTRIBUTES = Collections.unmodifiableMap(Collections.emptyMap());
    private static final int DEFAULT_TOTAL_ATTRIBUTE_COUNT = 0;

    abstract long getEpochNanos();

    abstract String getName();

    abstract Map<String, AttributeValue> getAttributes();

    abstract int getTotalAttributeCount();

    TimedEvent() {
    }

    static TimedEvent create(long epochNanos, String name) {
        return TimedEvent.create(epochNanos, name, EMPTY_ATTRIBUTES);
    }

    static TimedEvent create(long epochNanos, String name, Map<String, AttributeValue> attributes) {
        return new AutoValue_TimedEvent_RawTimedEvent(epochNanos, name, attributes, attributes.size());
    }

    static TimedEvent create(long epochNanos, String name, Map<String, AttributeValue> attributes, int totalAttributeCount) {
        return new AutoValue_TimedEvent_RawTimedEvent(epochNanos, name, attributes, totalAttributeCount);
    }

    static TimedEvent create(long epochNanos, Event event) {
        return new AutoValue_TimedEvent_RawTimedEventWithEvent(epochNanos, event, 0);
    }

    @AutoValue
    @Immutable
    static abstract class RawTimedEvent
    extends TimedEvent {
        RawTimedEvent() {
        }
    }

    @AutoValue
    @Immutable
    static abstract class RawTimedEventWithEvent
    extends TimedEvent {
        RawTimedEventWithEvent() {
        }

        abstract Event getEvent();

        @Override
        String getName() {
            return this.getEvent().getName();
        }

        @Override
        Map<String, AttributeValue> getAttributes() {
            return this.getEvent().getAttributes();
        }

        @Override
        abstract int getTotalAttributeCount();
    }
}

