/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.correlationcontext;

import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.Entry;
import io.opentelemetry.correlationcontext.EntryKey;
import io.opentelemetry.correlationcontext.EntryMetadata;
import io.opentelemetry.correlationcontext.EntryValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class CorrelationContextSdk
implements CorrelationContext {
    private final Map<EntryKey, Entry> entries;
    @Nullable
    private final CorrelationContext parent;

    private CorrelationContextSdk(Map<? extends EntryKey, ? extends Entry> entries, CorrelationContext parent) {
        this.entries = Collections.unmodifiableMap(new HashMap<EntryKey, Entry>(Objects.requireNonNull(entries, "entries")));
        this.parent = parent;
    }

    public Collection<Entry> getEntries() {
        HashMap<EntryKey, Entry> combined = new HashMap<EntryKey, Entry>(this.entries);
        if (this.parent != null) {
            for (Entry entry : this.parent.getEntries()) {
                if (combined.containsKey(entry.getKey())) continue;
                combined.put(entry.getKey(), entry);
            }
        }
        Iterator it = combined.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        return Collections.unmodifiableCollection(combined.values());
    }

    @Nullable
    public EntryValue getEntryValue(EntryKey entryKey) {
        Entry entry = this.entries.get(entryKey);
        if (entry != null) {
            return entry.getValue();
        }
        return this.parent == null ? null : this.parent.getEntryValue(entryKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CorrelationContextSdk)) {
            return false;
        }
        CorrelationContextSdk distContextSdk = (CorrelationContextSdk)o;
        if (!this.entries.equals(distContextSdk.entries)) {
            return false;
        }
        return this.parent != null ? this.parent.equals(distContextSdk.parent) : distContextSdk.parent == null;
    }

    public int hashCode() {
        int result = this.entries.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    static class Builder
    implements CorrelationContext.Builder {
        @Nullable
        private CorrelationContext parent;
        private boolean noImplicitParent;
        private final Map<EntryKey, Entry> entries = new HashMap<EntryKey, Entry>();

        Builder() {
        }

        public CorrelationContext.Builder setParent(CorrelationContext parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        public CorrelationContext.Builder setNoParent() {
            this.parent = null;
            this.noImplicitParent = true;
            return this;
        }

        public CorrelationContext.Builder put(EntryKey key, EntryValue value, EntryMetadata entryMetadata) {
            this.entries.put(Objects.requireNonNull(key, "key"), Entry.create((EntryKey)key, (EntryValue)Objects.requireNonNull(value, "value"), (EntryMetadata)Objects.requireNonNull(entryMetadata, "entryMetadata")));
            return this;
        }

        public CorrelationContext.Builder remove(EntryKey key) {
            this.entries.remove(Objects.requireNonNull(key, "key"));
            if (this.parent != null && this.parent.getEntryValue(key) != null) {
                this.entries.put(key, null);
            }
            return this;
        }

        public CorrelationContextSdk build() {
            if (this.parent == null && !this.noImplicitParent) {
                this.parent = OpenTelemetry.getCorrelationContextManager().getCurrentContext();
            }
            return new CorrelationContextSdk(this.entries, this.parent);
        }
    }
}

