/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.internal.Obfuscated;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.MillisClock;
import io.opentelemetry.sdk.metrics.MeterSdkProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.TracerSdkManagement;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
extends DefaultOpenTelemetry {
    private static final AtomicBoolean INITIALIZED_GLOBAL = new AtomicBoolean();
    private final Clock clock;
    private final Resource resource;

    public static Builder builder() {
        return new Builder();
    }

    public static OpenTelemetrySdk get() {
        return (OpenTelemetrySdk)OpenTelemetry.get();
    }

    public static TracerSdkManagement getGlobalTracerManagement() {
        TracerProvider tracerProvider = OpenTelemetry.get().getTracerProvider();
        if (!(tracerProvider instanceof ObfuscatedTracerProvider)) {
            throw new IllegalStateException("Trying to access global TracerSdkManagement but global TracerProvider is not an instance created by this SDK.");
        }
        return (TracerSdkProvider)((ObfuscatedTracerProvider)tracerProvider).unobfuscate();
    }

    public static MeterSdkProvider getGlobalMeterProvider() {
        return (MeterSdkProvider)OpenTelemetry.get().getMeterProvider();
    }

    private OpenTelemetrySdk(TracerProvider tracerProvider, MeterProvider meterProvider, ContextPropagators contextPropagators, Clock clock, Resource resource) {
        super(tracerProvider, meterProvider, contextPropagators);
        this.clock = clock;
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Clock getClock() {
        return this.clock;
    }

    public TracerSdkManagement getTracerManagement() {
        return (TracerSdkProvider)((ObfuscatedTracerProvider)this.getTracerProvider()).unobfuscate();
    }

    public Builder toBuilder() {
        return new Builder().setTracerProvider(this.getTracerProvider()).setMeterProvider(this.getMeterProvider()).setPropagators(this.getPropagators()).setClock(this.clock).setResource(this.resource);
    }

    @ThreadSafe
    @VisibleForTesting
    static class ObfuscatedTracerProvider
    implements TracerProvider,
    Obfuscated<TracerProvider> {
        private final TracerProvider delegate;

        private ObfuscatedTracerProvider(TracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        public TracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    public static class Builder
    extends DefaultOpenTelemetry.Builder {
        private Clock clock;
        private Resource resource;

        public Builder setTracerProvider(TracerProvider tracerProvider) {
            if (!(tracerProvider instanceof TracerSdkProvider)) {
                throw new IllegalArgumentException("The OpenTelemetrySdk can only be configured with a TracerSdkProvider");
            }
            super.setTracerProvider(tracerProvider);
            return this;
        }

        public Builder setMeterProvider(MeterProvider meterProvider) {
            if (!(meterProvider instanceof MeterSdkProvider)) {
                throw new IllegalArgumentException("The OpenTelemetrySdk can only be configured with a MeterSdkProvider");
            }
            super.setMeterProvider(meterProvider);
            return this;
        }

        public Builder setPropagators(ContextPropagators propagators) {
            super.setPropagators(propagators);
            return this;
        }

        public Builder setClock(Clock clock) {
            Objects.requireNonNull(clock, "clock");
            this.clock = clock;
            return this;
        }

        public Builder setResource(Resource resource) {
            Objects.requireNonNull(resource, "resource");
            this.resource = resource;
            return this;
        }

        public OpenTelemetrySdk build() {
            MeterProvider meterProvider = this.buildMeterProvider();
            TracerProvider tracerProvider = this.buildTracerProvider();
            OpenTelemetrySdk sdk = new OpenTelemetrySdk(new ObfuscatedTracerProvider(tracerProvider), meterProvider, this.propagators, (Clock)(this.clock == null ? MillisClock.getInstance() : this.clock), this.resource == null ? Resource.getDefault() : this.resource);
            if (INITIALIZED_GLOBAL.compareAndSet(false, true)) {
                OpenTelemetry.set((OpenTelemetry)sdk);
            }
            return sdk;
        }

        private TracerProvider buildTracerProvider() {
            TracerProvider tracerProvider = this.tracerProvider;
            if (tracerProvider != null) {
                if (!(tracerProvider instanceof TracerSdkProvider)) {
                    throw new IllegalStateException("The OpenTelemetrySdk can only be configured with a TracerSdkProvider");
                }
                return tracerProvider;
            }
            TracerSdkProvider.Builder tracerProviderBuilder = TracerSdkProvider.builder();
            if (this.clock != null) {
                tracerProviderBuilder.setClock(this.clock);
            }
            if (this.resource != null) {
                tracerProviderBuilder.setResource(this.resource);
            }
            return tracerProviderBuilder.build();
        }

        private MeterProvider buildMeterProvider() {
            if (this.meterProvider != null) {
                return this.meterProvider;
            }
            MeterSdkProvider.Builder meterProviderBuilder = MeterSdkProvider.builder();
            if (this.clock != null) {
                meterProviderBuilder.setClock(this.clock);
            }
            if (this.resource != null) {
                meterProviderBuilder.setResource(this.resource);
            }
            return meterProviderBuilder.build();
        }
    }
}

