/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import java.util.Collection;

public final class IntervalMetricReaderBuilder {
    private final IntervalMetricReader.InternalState.Builder optionsBuilder;

    IntervalMetricReaderBuilder(IntervalMetricReader.InternalState.Builder optionsBuilder) {
        this.optionsBuilder = optionsBuilder;
    }

    public IntervalMetricReaderBuilder setExportIntervalMillis(long exportIntervalMillis) {
        this.optionsBuilder.setExportIntervalMillis(exportIntervalMillis);
        return this;
    }

    public IntervalMetricReaderBuilder setMetricExporter(MetricExporter metricExporter) {
        this.optionsBuilder.setMetricExporter(metricExporter);
        return this;
    }

    public IntervalMetricReaderBuilder setMetricProducers(Collection<MetricProducer> metricProducers) {
        this.optionsBuilder.setMetricProducers(metricProducers);
        return this;
    }

    public IntervalMetricReader build() {
        IntervalMetricReader.InternalState internalState = this.optionsBuilder.build();
        Utils.checkArgument((internalState.getExportIntervalMillis() > 0L ? 1 : 0) != 0, (String)"Export interval must be positive");
        return new IntervalMetricReader(internalState);
    }
}

