/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.CountAggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.LastValueAggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.MinMaxSumCountAggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.SumAggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AggregatorFactory {
    public static AggregatorFactory sum(boolean alwaysCumulative) {
        return new SumAggregatorFactory(alwaysCumulative);
    }

    public static AggregatorFactory count(AggregationTemporality temporality) {
        return new CountAggregatorFactory(temporality);
    }

    public static AggregatorFactory lastValue() {
        return LastValueAggregatorFactory.INSTANCE;
    }

    public static AggregatorFactory minMaxSumCount() {
        return MinMaxSumCountAggregatorFactory.INSTANCE;
    }

    public <T> Aggregator<T> create(Resource var1, InstrumentationLibraryInfo var2, InstrumentDescriptor var3);
}

