/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.sdk.metrics.AbstractAccumulator;
import io.opentelemetry.sdk.metrics.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class SynchronousInstrumentAccumulator<T>
extends AbstractAccumulator {
    private final ConcurrentHashMap<Labels, AggregatorHandle<T>> aggregatorLabels = new ConcurrentHashMap();
    private final ReentrantLock collectLock = new ReentrantLock();
    private final Aggregator<T> aggregator;
    private final InstrumentProcessor<T> instrumentProcessor;

    static <T> SynchronousInstrumentAccumulator<T> create(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor) {
        Aggregator aggregator = SynchronousInstrumentAccumulator.getAggregator(meterProviderSharedState, meterSharedState, descriptor);
        return new SynchronousInstrumentAccumulator(aggregator, new InstrumentProcessor(aggregator, meterProviderSharedState.getStartEpochNanos()));
    }

    SynchronousInstrumentAccumulator(Aggregator<T> aggregator, InstrumentProcessor<T> instrumentProcessor) {
        this.aggregator = aggregator;
        this.instrumentProcessor = instrumentProcessor;
    }

    AggregatorHandle<?> bind(Labels labels) {
        AggregatorHandle<T> boundAggregatorHandle;
        Objects.requireNonNull(labels, "labels");
        AggregatorHandle<T> aggregatorHandle = this.aggregatorLabels.get(labels);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while ((boundAggregatorHandle = this.aggregatorLabels.putIfAbsent(labels, aggregatorHandle)) != null) {
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.aggregatorLabels.remove(labels, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<MetricData> collectAll(long epochNanos) {
        this.collectLock.lock();
        try {
            for (Map.Entry<Labels, AggregatorHandle<T>> entry : this.aggregatorLabels.entrySet()) {
                T accumulation;
                boolean unmappedEntry = entry.getValue().tryUnmap();
                if (unmappedEntry) {
                    this.aggregatorLabels.remove(entry.getKey(), entry.getValue());
                }
                if ((accumulation = entry.getValue().accumulateThenReset()) == null) continue;
                this.instrumentProcessor.batch(entry.getKey(), accumulation);
            }
            List<MetricData> list = this.instrumentProcessor.completeCollectionCycle(epochNanos);
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }
}

