/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.concurrent.atomic.LongAdder;

public final class LongSumAggregator
extends AbstractAggregator {
    private static final AggregatorFactory AGGREGATOR_FACTORY = LongSumAggregator::new;
    private final LongAdder current = new LongAdder();

    public static AggregatorFactory getFactory() {
        return AGGREGATOR_FACTORY;
    }

    @Override
    void doMergeAndReset(Aggregator aggregator) {
        LongSumAggregator other = (LongSumAggregator)aggregator;
        other.current.add(this.current.sumThenReset());
    }

    @Override
    public MetricData.Point toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        return MetricData.LongPoint.create(startEpochNanos, epochNanos, labels, this.current.sum());
    }

    @Override
    public void doRecordLong(long value) {
        this.current.add(value);
    }
}

