/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.trace.AutoValue_SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class SpanContext {
    private static final SpanContext INVALID = SpanContext.create(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), TraceState.getDefault());

    public static SpanContext getInvalid() {
        return INVALID;
    }

    public static SpanContext create(TraceId traceId, SpanId spanId, TraceFlags traceFlags, TraceState traceState) {
        return new AutoValue_SpanContext(traceId, spanId, traceFlags, traceState, false);
    }

    public static SpanContext createFromRemoteParent(TraceId traceId, SpanId spanId, TraceFlags traceFlags, TraceState traceState) {
        return new AutoValue_SpanContext(traceId, spanId, traceFlags, traceState, true);
    }

    public abstract TraceId getTraceId();

    public abstract SpanId getSpanId();

    public abstract TraceFlags getTraceFlags();

    public abstract TraceState getTraceState();

    public boolean isValid() {
        return this.getTraceId().isValid() && this.getSpanId().isValid();
    }

    public abstract boolean isRemote();
}

