/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.internal;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils {
    public static final int NAME_MAX_LENGTH = 255;

    public static boolean isPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isValidMetricName(String metricName) {
        if (metricName.isEmpty() || metricName.length() > 255) {
            return false;
        }
        String pattern = "[aA-zZ][aA-zZ0-9_\\-.]*";
        return metricName.matches(pattern);
    }

    public static String padLeft(String value, int length) {
        if (value == null || length <= 0) {
            throw new IllegalArgumentException();
        }
        if (value.length() >= length) {
            return value;
        }
        return String.format("%1$" + length + "s", value).replace(' ', '0');
    }

    private StringUtils() {
    }
}

