/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace.propagation;

import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import io.opentelemetry.trace.propagation.HttpTraceContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public class B3Propagator
implements HttpTextFormat<SpanContext> {
    private static final Logger logger = Logger.getLogger(HttpTraceContext.class.getName());
    static final String TRACE_ID_HEADER = "X-B3-TraceId";
    static final String SPAN_ID_HEADER = "X-B3-SpanId";
    static final String SAMPLED_HEADER = "X-B3-Sampled";
    static final String TRUE_INT = "1";
    static final String FALSE_INT = "0";
    static final String COMBINED_HEADER = "b3";
    static final String COMBINED_HEADER_DELIMITER = "-";
    private static final int MAX_TRACE_ID_LENGTH = 2 * TraceId.getSize();
    private static final int MAX_SPAN_ID_LENGTH = 2 * SpanId.getSize();
    private static final TraceFlags SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(true).build();
    private static final TraceFlags NOT_SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(false).build();
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-B3-Sampled"));
    private final boolean singleHeader;

    public B3Propagator() {
        this(false);
    }

    public B3Propagator(boolean singleHeader) {
        this.singleHeader = singleHeader;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(SpanContext spanContext, C carrier, HttpTextFormat.Setter<C> setter) {
        String sampled;
        Utils.checkNotNull(spanContext, "spanContext");
        Utils.checkNotNull(setter, "setter");
        Utils.checkNotNull(carrier, "carrier");
        String string = sampled = spanContext.getTraceFlags().isSampled() ? TRUE_INT : FALSE_INT;
        if (this.singleHeader) {
            setter.set(carrier, COMBINED_HEADER, spanContext.getTraceId().toLowerBase16() + COMBINED_HEADER_DELIMITER + spanContext.getSpanId().toLowerBase16() + COMBINED_HEADER_DELIMITER + sampled);
        } else {
            setter.set(carrier, TRACE_ID_HEADER, spanContext.getTraceId().toLowerBase16());
            setter.set(carrier, SPAN_ID_HEADER, spanContext.getSpanId().toLowerBase16());
            setter.set(carrier, SAMPLED_HEADER, sampled);
        }
    }

    public <C> SpanContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
        Utils.checkNotNull(carrier, "carrier");
        Utils.checkNotNull(getter, "getter");
        if (this.singleHeader) {
            return B3Propagator.getSpanContextFromSingleHeader(carrier, getter);
        }
        return B3Propagator.getSpanContextFromMultipleHeaders(carrier, getter);
    }

    private static <C> SpanContext getSpanContextFromSingleHeader(C carrier, HttpTextFormat.Getter<C> getter) {
        String value = getter.get(carrier, COMBINED_HEADER);
        if (StringUtils.isNullOrEmpty(value)) {
            logger.info("Missing or empty combined header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String[] parts = value.split(COMBINED_HEADER_DELIMITER);
        if (parts.length < 2 || parts.length > 4) {
            logger.info("Invalid combined header 'b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String traceId = parts[0];
        if (!B3Propagator.isTraceIdValid(traceId)) {
            logger.info("Invalid TraceId in B3 header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = parts[1];
        if (!B3Propagator.isSpanIdValid(spanId)) {
            logger.info("Invalid SpanId in B3 header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String sampled = parts.length >= 3 ? parts[2] : null;
        return B3Propagator.buildSpanContext(traceId, spanId, sampled);
    }

    private static <C> SpanContext getSpanContextFromMultipleHeaders(C carrier, HttpTextFormat.Getter<C> getter) {
        String traceId = getter.get(carrier, TRACE_ID_HEADER);
        if (!B3Propagator.isTraceIdValid(traceId)) {
            logger.info("Invalid TraceId in B3 header: X-B3-TraceId'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = getter.get(carrier, SPAN_ID_HEADER);
        if (!B3Propagator.isSpanIdValid(spanId)) {
            logger.info("Invalid SpanId in B3 header: X-B3-SpanId'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String sampled = getter.get(carrier, SAMPLED_HEADER);
        return B3Propagator.buildSpanContext(traceId, spanId, sampled);
    }

    private static SpanContext buildSpanContext(String traceId, String spanId, String sampled) {
        try {
            TraceFlags traceFlags = TRUE_INT.equals(sampled) || Boolean.parseBoolean(sampled) ? SAMPLED_FLAGS : NOT_SAMPLED_FLAGS;
            return SpanContext.createFromRemoteParent(TraceId.fromLowerBase16(StringUtils.padLeft(traceId, MAX_TRACE_ID_LENGTH), 0), SpanId.fromLowerBase16(spanId, 0), traceFlags, TraceState.getDefault());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error parsing B3 header. Returning INVALID span context.", e);
            return SpanContext.getInvalid();
        }
    }

    private static boolean isTraceIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && value.length() <= MAX_TRACE_ID_LENGTH;
    }

    private static boolean isSpanIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && value.length() <= MAX_SPAN_ID_LENGTH;
    }
}

