/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.metrics;

import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.BatchRecorder;
import io.opentelemetry.metrics.Counter;
import io.opentelemetry.metrics.DoubleCounter;
import io.opentelemetry.metrics.DoubleMeasure;
import io.opentelemetry.metrics.DoubleObserver;
import io.opentelemetry.metrics.Instrument;
import io.opentelemetry.metrics.LabelSet;
import io.opentelemetry.metrics.LongCounter;
import io.opentelemetry.metrics.LongMeasure;
import io.opentelemetry.metrics.LongObserver;
import io.opentelemetry.metrics.Meter;
import io.opentelemetry.metrics.Observer;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultMeter
implements Meter {
    private static final DefaultMeter INSTANCE = new DefaultMeter();
    static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";

    public static Meter getInstance() {
        return INSTANCE;
    }

    @Override
    public DoubleCounter.Builder doubleCounterBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleCounter.NoopBuilder();
    }

    @Override
    public LongCounter.Builder longCounterBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongCounter.NoopBuilder();
    }

    @Override
    public DoubleMeasure.Builder doubleMeasureBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleMeasure.NoopBuilder();
    }

    @Override
    public LongMeasure.Builder longMeasureBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongMeasure.NoopBuilder();
    }

    @Override
    public DoubleObserver.Builder doubleObserverBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleObserver.NoopBuilder();
    }

    @Override
    public LongObserver.Builder longObserverBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongObserver.NoopBuilder();
    }

    @Override
    public BatchRecorder newBatchRecorder(String ... keyValuePairs) {
        Utils.validateLabelPairs(keyValuePairs);
        return new NoopBatchRecorder();
    }

    @Override
    public LabelSet createLabelSet(String ... keyValuePairs) {
        Utils.validateLabelPairs(keyValuePairs);
        return NoopLabelSet.INSTANCE;
    }

    @Override
    public LabelSet createLabelSet(Map<String, String> labels) {
        Utils.checkNotNull(labels, "labels");
        Utils.checkMapKeysNotNull(labels, "Null map keys are not allowed for LabelSet creation");
        return NoopLabelSet.INSTANCE;
    }

    private DefaultMeter() {
    }

    private static enum NoopLabelSet implements LabelSet
    {
        INSTANCE;

    }

    private static abstract class NoopAbstractInstrumentBuilder<B extends NoopAbstractInstrumentBuilder<B>>
    implements Instrument.Builder {
        private NoopAbstractInstrumentBuilder() {
        }

        public B setDescription(String description) {
            Utils.checkNotNull(description, "description");
            return this.getThis();
        }

        public B setUnit(String unit) {
            Utils.checkNotNull(unit, "unit");
            return this.getThis();
        }

        public B setLabelKeys(List<String> labelKeys) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            return this.getThis();
        }

        public B setConstantLabels(Map<String, String> constantLabels) {
            Utils.checkMapKeysNotNull(Utils.checkNotNull(constantLabels, "constantLabels"), "constantLabel");
            return this.getThis();
        }

        protected abstract B getThis();
    }

    private static abstract class NoopAbstractObserverBuilder<B extends NoopAbstractObserverBuilder<B>>
    extends NoopAbstractInstrumentBuilder<B>
    implements Observer.Builder {
        private NoopAbstractObserverBuilder() {
        }

        public B setMonotonic(boolean monotonic) {
            return (B)((NoopAbstractObserverBuilder)this.getThis());
        }
    }

    private static abstract class NoopAbstractCounterBuilder<B extends NoopAbstractCounterBuilder<B>>
    extends NoopAbstractInstrumentBuilder<B>
    implements Counter.Builder {
        private NoopAbstractCounterBuilder() {
        }

        public B setMonotonic(boolean monotonic) {
            return (B)((NoopAbstractCounterBuilder)this.getThis());
        }
    }

    private static final class NoopBatchRecorder
    implements BatchRecorder {
        private NoopBatchRecorder() {
        }

        @Override
        public BatchRecorder put(LongMeasure measure, long value) {
            Utils.checkNotNull(measure, "measure");
            return this;
        }

        @Override
        public BatchRecorder put(DoubleMeasure measure, double value) {
            Utils.checkNotNull(measure, "measure");
            return this;
        }

        @Override
        public BatchRecorder put(LongCounter counter, long value) {
            Utils.checkNotNull(counter, "counter");
            return this;
        }

        @Override
        public BatchRecorder put(DoubleCounter counter, double value) {
            Utils.checkNotNull(counter, "counter");
            return this;
        }

        @Override
        public void record() {
        }
    }

    @Immutable
    private static final class NoopLongObserver
    implements LongObserver {
        private NoopLongObserver() {
        }

        @Override
        public void setCallback(Observer.Callback<LongObserver.ResultLongObserver> metricUpdater) {
            Utils.checkNotNull(metricUpdater, "metricUpdater");
        }

        private static final class NoopBuilder
        extends NoopAbstractObserverBuilder<NoopBuilder>
        implements LongObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongObserver build() {
                return new NoopLongObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleObserver
    implements DoubleObserver {
        private NoopDoubleObserver() {
        }

        @Override
        public void setCallback(Observer.Callback<DoubleObserver.ResultDoubleObserver> metricUpdater) {
            Utils.checkNotNull(metricUpdater, "metricUpdater");
        }

        private static final class NoopBuilder
        extends NoopAbstractObserverBuilder<NoopBuilder>
        implements DoubleObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleObserver build() {
                return new NoopDoubleObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongMeasure
    implements LongMeasure {
        private NoopLongMeasure() {
        }

        @Override
        public void record(long value, String ... labelKeyValuePairs) {
            Utils.checkArgument(value >= 0L, "Unsupported negative values.");
            Utils.validateLabelPairs(labelKeyValuePairs);
        }

        @Override
        public NoopBoundLongMeasure bind(String ... labelKeyValuePairs) {
            Utils.validateLabelPairs(labelKeyValuePairs);
            return NoopBoundLongMeasure.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongMeasure.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongMeasure build() {
                return new NoopLongMeasure();
            }

            @Override
            public LongMeasure.Builder setAbsolute(boolean absolute) {
                return this;
            }
        }

        @Immutable
        private static enum NoopBoundLongMeasure implements LongMeasure.BoundLongMeasure
        {
            INSTANCE;


            @Override
            public void record(long value) {
                Utils.checkArgument(value >= 0L, "Unsupported negative values.");
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleMeasure
    implements DoubleMeasure {
        private NoopDoubleMeasure() {
        }

        @Override
        public void record(double value, String ... labelKeyValuePairs) {
            Utils.checkArgument(value >= 0.0, "Unsupported negative values.");
            Utils.validateLabelPairs(labelKeyValuePairs);
        }

        @Override
        public NoopBoundDoubleMeasure bind(String ... labelKeyValuePairs) {
            Utils.validateLabelPairs(labelKeyValuePairs);
            return NoopBoundDoubleMeasure.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleMeasure.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleMeasure build() {
                return new NoopDoubleMeasure();
            }

            @Override
            public DoubleMeasure.Builder setAbsolute(boolean absolute) {
                return this;
            }
        }

        @Immutable
        private static enum NoopBoundDoubleMeasure implements DoubleMeasure.BoundDoubleMeasure
        {
            INSTANCE;


            @Override
            public void record(double value) {
                Utils.checkArgument(value >= 0.0, "Unsupported negative values.");
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopLongCounter
    implements LongCounter {
        private NoopLongCounter() {
        }

        @Override
        public void add(long delta, String ... labelKeyValuePairs) {
        }

        @Override
        public NoopBoundLongCounter bind(String ... labelKeyValuePairs) {
            Utils.validateLabelPairs(labelKeyValuePairs);
            return NoopBoundLongCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractCounterBuilder<NoopBuilder>
        implements LongCounter.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongCounter build() {
                return new NoopLongCounter();
            }
        }

        @Immutable
        private static enum NoopBoundLongCounter implements LongCounter.BoundLongCounter
        {
            INSTANCE;


            @Override
            public void add(long delta) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleCounter
    implements DoubleCounter {
        private NoopDoubleCounter() {
        }

        @Override
        public void add(double delta, String ... labelKeyValuePairs) {
            Utils.validateLabelPairs(labelKeyValuePairs);
        }

        @Override
        public NoopBoundDoubleCounter bind(String ... labelKeyValuePairs) {
            Utils.validateLabelPairs(labelKeyValuePairs);
            return NoopBoundDoubleCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractCounterBuilder<NoopBuilder>
        implements DoubleCounter.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleCounter build() {
                return new NoopDoubleCounter();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleCounter implements DoubleCounter.BoundDoubleCounter
        {
            INSTANCE;


            @Override
            public void add(double delta) {
            }

            @Override
            public void unbind() {
            }
        }
    }
}

