/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry;

import io.opentelemetry.correlationcontext.CorrelationContextManager;
import io.opentelemetry.correlationcontext.DefaultCorrelationContextManagerProvider;
import io.opentelemetry.correlationcontext.spi.CorrelationContextManagerProvider;
import io.opentelemetry.metrics.DefaultMetricsProvider;
import io.opentelemetry.metrics.MeterProvider;
import io.opentelemetry.metrics.spi.MetricsProvider;
import io.opentelemetry.trace.DefaultTraceProvider;
import io.opentelemetry.trace.TracerProvider;
import io.opentelemetry.trace.spi.TraceProvider;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetry {
    @Nullable
    private static volatile OpenTelemetry instance;
    private final TracerProvider tracerProvider;
    private final MeterProvider meterProvider;
    private final CorrelationContextManager contextManager;

    public static TracerProvider getTracerProvider() {
        return OpenTelemetry.getInstance().tracerProvider;
    }

    public static MeterProvider getMeterProvider() {
        return OpenTelemetry.getInstance().meterProvider;
    }

    public static CorrelationContextManager getCorrelationContextManager() {
        return OpenTelemetry.getInstance().contextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OpenTelemetry getInstance() {
        if (instance != null) return instance;
        Class<OpenTelemetry> clazz = OpenTelemetry.class;
        synchronized (OpenTelemetry.class) {
            if (instance != null) return instance;
            instance = new OpenTelemetry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private OpenTelemetry() {
        TraceProvider traceProvider = OpenTelemetry.loadSpi(TraceProvider.class);
        this.tracerProvider = traceProvider != null ? traceProvider.create() : DefaultTraceProvider.getInstance().create();
        MetricsProvider metricsProvider = OpenTelemetry.loadSpi(MetricsProvider.class);
        this.meterProvider = metricsProvider != null ? metricsProvider.create() : DefaultMetricsProvider.getInstance().create();
        CorrelationContextManagerProvider contextManagerProvider = OpenTelemetry.loadSpi(CorrelationContextManagerProvider.class);
        this.contextManager = contextManagerProvider != null ? contextManagerProvider.create() : DefaultCorrelationContextManagerProvider.getInstance().create();
    }

    @Nullable
    private static <T> T loadSpi(Class<T> providerClass) {
        String specifiedProvider = System.getProperty(providerClass.getName());
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        for (T provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }

    static void reset() {
        instance = null;
    }
}

