/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.trace.propagation.HttpTraceContext;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultTracer
implements Tracer {
    private static final DefaultTracer INSTANCE = new DefaultTracer();
    private static final HttpTextFormat<SpanContext> HTTP_TEXT_FORMAT = new HttpTraceContext();

    public static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public Span getCurrentSpan() {
        return TracingContextUtils.getCurrentSpan();
    }

    @Override
    public Scope withSpan(Span span) {
        return TracingContextUtils.currentContextWith(span);
    }

    @Override
    public Span.Builder spanBuilder(String spanName) {
        return NoopSpanBuilder.create(this, spanName);
    }

    @Override
    public HttpTextFormat<SpanContext> getHttpTextFormat() {
        return HTTP_TEXT_FORMAT;
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements Span.Builder {
        private final Tracer tracer;
        private boolean isRootSpan;
        private SpanContext spanContext;

        static NoopSpanBuilder create(Tracer tracer, String spanName) {
            return new NoopSpanBuilder(tracer, spanName);
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null && !this.isRootSpan) {
                this.spanContext = this.tracer.getCurrentSpan().getContext();
            }
            return this.spanContext != null && !SpanContext.getInvalid().equals(this.spanContext) ? new DefaultSpan(this.spanContext) : DefaultSpan.createRandom();
        }

        @Override
        public NoopSpanBuilder setParent(Span parent) {
            Utils.checkNotNull(parent, "parent");
            this.spanContext = parent.getContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setParent(SpanContext remoteParent) {
            Utils.checkNotNull(remoteParent, "remoteParent");
            this.spanContext = remoteParent;
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.isRootSpan = true;
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Map<String, AttributeValue> attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(Link link) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, AttributeValue value) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(Span.Kind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp) {
            Utils.checkArgument(startTimestamp >= 0L, "Negative startTimestamp");
            return this;
        }

        private NoopSpanBuilder(Tracer tracer, String name) {
            Utils.checkNotNull(name, "name");
            this.tracer = tracer;
        }
    }
}

