/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueBoolean;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueDouble;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueLong;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueString;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AttributeValue {
    public static AttributeValue stringAttributeValue(String stringValue) {
        return AttributeValueString.create(stringValue);
    }

    public static AttributeValue booleanAttributeValue(boolean booleanValue) {
        return AttributeValueBoolean.create(booleanValue);
    }

    public static AttributeValue longAttributeValue(long longValue) {
        return AttributeValueLong.create(longValue);
    }

    public static AttributeValue doubleAttributeValue(double doubleValue) {
        return AttributeValueDouble.create(doubleValue);
    }

    AttributeValue() {
    }

    public String getStringValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public boolean getBooleanValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public long getLongValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public double getDoubleValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public abstract Type getType();

    @Immutable
    @AutoValue
    static abstract class AttributeValueDouble
    extends AttributeValue {
        AttributeValueDouble() {
        }

        static AttributeValue create(double doubleValue) {
            return new AutoValue_AttributeValue_AttributeValueDouble(doubleValue);
        }

        @Override
        public final Type getType() {
            return Type.DOUBLE;
        }

        @Override
        public abstract double getDoubleValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueLong
    extends AttributeValue {
        AttributeValueLong() {
        }

        static AttributeValue create(long longValue) {
            return new AutoValue_AttributeValue_AttributeValueLong(longValue);
        }

        @Override
        public final Type getType() {
            return Type.LONG;
        }

        @Override
        public abstract long getLongValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueBoolean
    extends AttributeValue {
        AttributeValueBoolean() {
        }

        static AttributeValue create(boolean booleanValue) {
            return new AutoValue_AttributeValue_AttributeValueBoolean(booleanValue);
        }

        @Override
        public final Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        public abstract boolean getBooleanValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueString
    extends AttributeValue {
        AttributeValueString() {
        }

        static AttributeValue create(String stringValue) {
            return new AutoValue_AttributeValue_AttributeValueString(stringValue);
        }

        @Override
        public final Type getType() {
            return Type.STRING;
        }

        @Override
        @Nullable
        public abstract String getStringValue();
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        LONG,
        DOUBLE;

    }
}

