/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server.handler.gzip;

import io.opentelemetry.testing.internal.jetty.http.GZIPContentDecoder;
import io.opentelemetry.testing.internal.jetty.io.ByteBufferPool;
import io.opentelemetry.testing.internal.jetty.server.HttpInput;
import io.opentelemetry.testing.internal.jetty.util.component.Destroyable;
import java.nio.ByteBuffer;

public class GzipHttpInputInterceptor
implements HttpInput.Interceptor,
Destroyable {
    private final Decoder _decoder;
    private ByteBuffer _chunk;

    public GzipHttpInputInterceptor(ByteBufferPool pool, int bufferSize) {
        this._decoder = new Decoder(pool, bufferSize);
    }

    @Override
    public HttpInput.Content readFrom(HttpInput.Content content) {
        this._decoder.decodeChunks(content.getByteBuffer());
        final ByteBuffer chunk = this._chunk;
        if (chunk == null) {
            return null;
        }
        return new HttpInput.Content(chunk){

            @Override
            public void succeeded() {
                GzipHttpInputInterceptor.this._decoder.release(chunk);
            }

            @Override
            public void failed(Throwable x) {
                GzipHttpInputInterceptor.this._decoder.release(chunk);
            }
        };
    }

    @Override
    public void destroy() {
        this._decoder.destroy();
    }

    private class Decoder
    extends GZIPContentDecoder {
        private Decoder(ByteBufferPool pool, int bufferSize) {
            super(pool, bufferSize);
        }

        @Override
        protected boolean decodedChunk(ByteBuffer chunk) {
            GzipHttpInputInterceptor.this._chunk = chunk;
            return true;
        }

        @Override
        public void decodeChunks(ByteBuffer compressed) {
            GzipHttpInputInterceptor.this._chunk = null;
            super.decodeChunks(compressed);
        }
    }
}

